/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.event.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.event.client.EventJsonSerializer;
import com.proofpoint.event.client.EventTypeMetadata;
import com.proofpoint.event.client.InvalidEventException;
import com.proofpoint.node.NodeInfo;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class JsonEventSerializer {
    private final NodeInfo nodeinfo;
    private final Map<Class<?>, EventTypeMetadata<?>> metadataMap;

    @Inject
    public JsonEventSerializer(NodeInfo nodeInfo, Set<EventTypeMetadata<?>> eventTypes) {
        this.nodeinfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull(eventTypes, (Object)"eventTypes is null");
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (EventTypeMetadata<?> eventType : eventTypes) {
            map.put(eventType.getEventClass(), eventType);
        }
        this.metadataMap = map.build();
    }

    public JsonEventSerializer(NodeInfo nodeInfo, Class<?> ... eventClasses) {
        this(nodeInfo, EventTypeMetadata.getValidEventTypeMetaDataSet(eventClasses));
    }

    public <T> void serialize(T event, @Nullable String token, JsonGenerator jsonGenerator) throws IOException {
        Preconditions.checkNotNull(event, (Object)"event is null");
        Preconditions.checkNotNull((Object)jsonGenerator, (Object)"jsonGenerator is null");
        JsonSerializer<T> serializer = this.getSerializer(event, token);
        if (serializer == null) {
            throw new InvalidEventException("Event class [%s] has not been registered as an event", event.getClass().getName());
        }
        serializer.serialize(event, jsonGenerator, null);
    }

    private <T> JsonSerializer<T> getSerializer(T event, @Nullable String token) {
        EventTypeMetadata<?> metadata = this.metadataMap.get(event.getClass());
        if (metadata == null) {
            return null;
        }
        return new EventJsonSerializer(this.nodeinfo, token, metadata);
    }
}

