/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.event.client;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.event.client.EventClient;
import com.proofpoint.event.client.EventJsonSerializer;
import com.proofpoint.event.client.EventTypeMetadata;
import com.proofpoint.event.client.InvalidEventException;
import com.proofpoint.node.NodeInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

class JsonEventWriter {
    private final NodeInfo nodeInfo;
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, EventTypeMetadata<?>> metadataMap;

    @Inject
    public JsonEventWriter(NodeInfo nodeInfo, Set<EventTypeMetadata<?>> eventTypes) {
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull(eventTypes, (Object)"eventTypes is null");
        this.jsonFactory = new JsonFactory();
        ImmutableMap.Builder metadataBuilder = ImmutableMap.builder();
        for (EventTypeMetadata<?> eventType : eventTypes) {
            metadataBuilder.put(eventType.getEventClass(), eventType);
        }
        this.metadataMap = metadataBuilder.build();
    }

    public <T> void writeEvents(EventClient.EventGenerator<T> events, final @Nullable String token, OutputStream out) throws IOException {
        Preconditions.checkNotNull(events, (Object)"events is null");
        Preconditions.checkNotNull((Object)out, (Object)"out is null");
        final JsonGenerator jsonGenerator = this.jsonFactory.createJsonGenerator(out, JsonEncoding.UTF8);
        jsonGenerator.writeStartArray();
        events.generate(new EventClient.EventPoster<T>(){

            @Override
            public void post(T event) throws IOException {
                JsonSerializer serializer = JsonEventWriter.this.getSerializer(event, token);
                if (serializer == null) {
                    throw new InvalidEventException("Event class [%s] has not been registered as an event", event.getClass().getName());
                }
                serializer.serialize(event, jsonGenerator, null);
            }
        });
        jsonGenerator.writeEndArray();
        jsonGenerator.flush();
    }

    private <T> JsonSerializer<T> getSerializer(T event, @Nullable String token) {
        EventTypeMetadata<?> metadata = this.metadataMap.get(event.getClass());
        if (metadata == null) {
            return null;
        }
        return new EventJsonSerializer(this.nodeInfo, token, metadata);
    }
}

