/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class AdminFilter
implements Filter {
    private static final String ADMIN_PATH = "/admin";
    private static final String ADMIN_PATH_PREFIX = "/admin/";
    private static final Predicate<String> IS_ADMIN_PATH_PREDICATE = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            if (input == null) {
                return false;
            }
            return input.equals(AdminFilter.ADMIN_PATH) || input.startsWith(AdminFilter.ADMIN_PATH_PREFIX);
        }
    };
    private final Predicate<String> forThisPortPredicate;

    public AdminFilter(boolean isAdmin) {
        this.forThisPortPredicate = isAdmin ? IS_ADMIN_PATH_PREDICATE : Predicates.not(IS_ADMIN_PATH_PREDICATE);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String path = request.getPathInfo();
        if (this.forThisPortPredicate.apply((Object)path)) {
            chain.doFilter(servletRequest, servletResponse);
        } else {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.sendError(404);
        }
    }

    public void destroy() {
    }
}

