/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import com.proofpoint.http.server.CurrentTimeMillisProvider;
import com.proofpoint.http.server.HttpRequestEvent;
import com.proofpoint.http.server.SystemCurrentTimeMillisProvider;
import com.proofpoint.log.Logging;
import com.proofpoint.tracetoken.TraceTokenManager;
import java.io.IOException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

class DelimitedRequestLog
implements RequestLog {
    private final TraceTokenManager traceTokenManager;
    private final CurrentTimeMillisProvider currentTimeMillisProvider;
    private final Appender<HttpRequestEvent> appender;

    public DelimitedRequestLog(String filename, int maxHistory, long maxSizeInBytes, TraceTokenManager traceTokenManager) throws IOException {
        this(filename, maxHistory, maxSizeInBytes, traceTokenManager, new SystemCurrentTimeMillisProvider());
    }

    public DelimitedRequestLog(String filename, int maxHistory, long maxSizeInBytes, TraceTokenManager traceTokenManager, CurrentTimeMillisProvider currentTimeMillisProvider) throws IOException {
        this.traceTokenManager = traceTokenManager;
        this.currentTimeMillisProvider = currentTimeMillisProvider;
        this.appender = Logging.createFileAppender((String)filename, (int)maxHistory, (long)maxSizeInBytes, (Encoder)new EventEncoder(), (LoggerContext)new LoggerContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response) {
        long currentTime = this.currentTimeMillisProvider.getCurrentTimeMillis();
        HttpRequestEvent event = HttpRequestEvent.createHttpRequestEvent(request, response, this.traceTokenManager, currentTime);
        Appender<HttpRequestEvent> appender = this.appender;
        synchronized (appender) {
            this.appender.doAppend((Object)event);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.appender.stop();
    }

    public boolean isRunning() {
        return true;
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }

    public boolean isFailed() {
        return false;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }

    private static class EventEncoder
    extends EncoderBase<HttpRequestEvent> {
        private DateTimeFormatter isoFormatter = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateHourMinuteSecondFraction()).appendTimeZoneOffset("Z", true, 2, 2).toFormatter();

        private EventEncoder() {
        }

        public void doEncode(HttpRequestEvent event) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append(this.isoFormatter.print((ReadableInstant)event.getTimeStamp())).append('\t').append(event.getClientAddress()).append('\t').append(event.getMethod()).append('\t').append(event.getRequestUri()).append('\t').append(event.getUser()).append('\t').append(event.getAgent()).append('\t').append(event.getResponseCode()).append('\t').append(event.getRequestSize()).append('\t').append(event.getResponseSize()).append('\t').append(event.getTimeToLastByte()).append('\t').append(event.getTraceToken()).append('\n');
            this.outputStream.write(builder.toString().getBytes("UTF-8"));
            this.outputStream.flush();
        }

        public void close() throws IOException {
        }
    }
}

