/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.log.Logger;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.security.HashLoginService;

public class HashLoginServiceProvider
implements Provider<HashLoginService> {
    private static final Logger log = Logger.get(HashLoginServiceProvider.class);
    private final HttpServerConfig config;

    @Inject
    public HashLoginServiceProvider(HttpServerConfig config) {
        this.config = config;
    }

    public HashLoginService get() {
        String authConfig = this.config.getUserAuthFile();
        try {
            if (!StringUtils.isEmpty((String)authConfig)) {
                HashLoginService service = new HashLoginService("Proofpoint", authConfig);
                service.loadUsers();
                return service;
            }
            return null;
        }
        catch (IOException e) {
            log.error((Throwable)e, "Error when loading user auth info from %s", new Object[]{authConfig});
            return null;
        }
    }
}

