/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.configuration.ConfigurationModule;
import com.proofpoint.discovery.client.announce.AnnouncementHttpServerInfo;
import com.proofpoint.http.server.DetailedRequestStats;
import com.proofpoint.http.server.HttpServer;
import com.proofpoint.http.server.HttpServerBinder;
import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.http.server.HttpServerInfo;
import com.proofpoint.http.server.HttpServerProvider;
import com.proofpoint.http.server.LocalAnnouncementHttpServerInfo;
import com.proofpoint.http.server.QueryStringFilter;
import com.proofpoint.http.server.RequestStats;
import com.proofpoint.http.server.TheAdminServlet;
import com.proofpoint.http.server.TheServlet;
import com.proofpoint.reporting.ReportBinder;
import javax.servlet.Filter;
import org.weakref.jmx.ObjectNameBuilder;

public class HttpServerModule
implements Module {
    public static final String REALM_NAME = "Proofpoint";

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(HttpServer.class).toProvider(HttpServerProvider.class).in(Scopes.SINGLETON);
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        binder.bind(QueryStringFilter.class).in(Scopes.SINGLETON);
        binder.bind(RequestStats.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheAdminServlet.class);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class, TheServlet.class);
        ReportBinder.reportBinder((Binder)binder).export(HttpServer.class).withGeneratedName();
        ReportBinder.reportBinder((Binder)binder).bindReportCollection(DetailedRequestStats.class).as(new ObjectNameBuilder(RequestStats.class.getPackage().getName()).withProperty("type", "HttpServer").build());
        ConfigurationModule.bindConfig((Binder)binder).to(HttpServerConfig.class);
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class).in(Scopes.SINGLETON);
    }
}

