/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import com.proofpoint.http.server.Inet4Network;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.List;

class Inet4Networks {
    private static final List<Inet4Network> PRIVATE_NETWORKS = ImmutableList.of((Object)Inet4Network.fromCidr("127.0.0.0/8"), (Object)Inet4Network.fromCidr("169.254.0.0/16"), (Object)Inet4Network.fromCidr("192.168.0.0/16"), (Object)Inet4Network.fromCidr("172.16.0.0/12"), (Object)Inet4Network.fromCidr("10.0.0.0/8"));

    public static boolean isPrivateNetworkAddress(String inetAddress) {
        Inet4Address address = InetAddresses.getCoercedIPv4Address((InetAddress)InetAddresses.forString((String)inetAddress));
        return Inet4Networks.isPrivateNetworkAddress(address);
    }

    public static boolean isPrivateNetworkAddress(Inet4Address inetAddress) {
        for (Inet4Network privateNetwork : PRIVATE_NETWORKS) {
            if (!privateNetwork.containsAddress(inetAddress)) continue;
            return true;
        }
        return false;
    }

    private Inet4Networks() {
    }
}

