/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.proofpoint.tracetoken.TraceTokenManager;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class TraceTokenFilter
implements Filter {
    private final TraceTokenManager traceTokenManager;

    @Inject
    public TraceTokenFilter(TraceTokenManager traceTokenManager) {
        this.traceTokenManager = traceTokenManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String token = request.getHeader("X-Proofpoint-TraceToken");
        if (token != null) {
            this.traceTokenManager.registerRequestToken(token);
        } else {
            this.traceTokenManager.createAndRegisterNewRequestToken();
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

