/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.proofpoint.jaxrs.ParsingException;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;

public class BeanValidationException
extends ParsingException {
    private ImmutableSet<ConstraintViolation<Object>> violations;

    public BeanValidationException(Set<ConstraintViolation<Object>> violations) {
        super(BeanValidationException.messagesFor(violations).toString());
        this.violations = ImmutableSet.copyOf(violations);
    }

    public List<String> getErrorMessages() {
        return BeanValidationException.messagesFor(this.violations);
    }

    public Set<ConstraintViolation<Object>> getViolations() {
        return this.violations;
    }

    private static List<String> messagesFor(Set<ConstraintViolation<Object>> violations) {
        ImmutableList.Builder messages = new ImmutableList.Builder();
        for (ConstraintViolation<Object> violation : violations) {
            messages.add((Object)(violation.getPropertyPath().toString() + " " + violation.getMessage()));
        }
        return messages.build();
    }
}

