/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.base.Preconditions;
import com.proofpoint.jaxrs.RequestStats;
import com.proofpoint.units.Duration;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

class TimingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String START_TIME_KEY = TimingFilter.class.getName() + ".start-time";
    private final String methodName;
    private final RequestStats requestStats;

    TimingFilter(String methodName, RequestStats requestStats) {
        this.methodName = (String)Preconditions.checkNotNull((Object)methodName, (Object)"methodName is null");
        this.requestStats = (RequestStats)Preconditions.checkNotNull((Object)requestStats, (Object)"requestStats is null");
    }

    public void filter(ContainerRequestContext request) {
        request.setProperty(START_TIME_KEY, (Object)System.nanoTime());
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Long startTime = (Long)request.getProperty(START_TIME_KEY);
        this.requestStats.requestTime(this.methodName, response.getStatus()).add(Duration.nanosSince((long)startTime));
    }
}

