/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.proofpoint.jaxrs.RequestStats;
import com.proofpoint.jaxrs.TimingFilter;
import com.proofpoint.reporting.ReportCollectionFactory;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.ws.rs.Path;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.weakref.jmx.ObjectNameBuilder;

@Provider
class TimingResourceDynamicFeature
implements DynamicFeature {
    private final ReportCollectionFactory reportCollectionFactory;
    private final LoadingCache<String, RequestStats> requestStatsLoadingCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, RequestStats>(){

        public RequestStats load(@Nonnull String objectName) {
            return (RequestStats)TimingResourceDynamicFeature.this.reportCollectionFactory.createReportCollection(RequestStats.class, objectName);
        }
    });

    @Inject
    public TimingResourceDynamicFeature(ReportCollectionFactory reportCollectionFactory) {
        this.reportCollectionFactory = (ReportCollectionFactory)Preconditions.checkNotNull((Object)reportCollectionFactory, (Object)"reportCollectionFactory is null");
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Class resourceClass = resourceInfo.getResourceClass();
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceClass == null || resourceMethod == null) {
            return;
        }
        if (!TimingResourceDynamicFeature.isJaxRsResource(resourceClass)) {
            return;
        }
        String objectName = new ObjectNameBuilder(resourceClass.getPackage().getName()).withProperty("type", resourceClass.getSimpleName()).build();
        RequestStats requestStats = (RequestStats)this.requestStatsLoadingCache.getUnchecked((Object)objectName);
        featureContext.register((Object)new TimingFilter(resourceMethod.getName(), requestStats));
    }

    private static boolean isJaxRsResource(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isAnnotationPresent(Path.class)) {
            return true;
        }
        if (TimingResourceDynamicFeature.isJaxRsResource(type.getSuperclass())) {
            return true;
        }
        for (Class<?> typeInterface : type.getInterfaces()) {
            if (!TimingResourceDynamicFeature.isJaxRsResource(typeInterface)) continue;
            return true;
        }
        return false;
    }
}

