/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import ch.qos.logback.classic.Level;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.IllegalFormatException;
import org.slf4j.LoggerFactory;

public class Logger {
    private final org.slf4j.Logger logger;

    @Inject
    Logger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    public static Logger get(Class<?> clazz) {
        org.slf4j.Logger logger = LoggerFactory.getLogger(clazz);
        return new Logger(logger);
    }

    public static Logger get(String name) {
        org.slf4j.Logger logger = LoggerFactory.getLogger((String)name);
        return new Logger(logger);
    }

    public void debug(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.error(this.illegalFormatMessageFor(Level.DEBUG, format, args), (Throwable)e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.debug(message);
        }
    }

    public void debug(Throwable exception, String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.error(this.illegalFormatMessageFor(Level.DEBUG, format, args), (Throwable)e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.debug(message, exception);
        }
    }

    public void info(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.error(this.illegalFormatMessageFor(Level.INFO, format, args), (Throwable)e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.info(message);
        }
    }

    public void warn(Throwable exception, String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.error(this.illegalFormatMessageFor(Level.WARN, format, args), (Throwable)e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.warn(message, exception);
        }
    }

    public void warn(String format, Object ... args) {
        this.warn(null, format, args);
    }

    public void error(Throwable exception, String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.error(this.illegalFormatMessageFor(Level.ERROR, format, args), (Throwable)e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.error(message, exception);
        }
    }

    public void error(Throwable exception) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(exception.getMessage(), exception);
        }
    }

    public void error(String format, Object ... args) {
        this.error(null, format, args);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    private String illegalFormatMessageFor(Level level, String message, Object ... args) {
        return String.format("Invalid format string while trying to log: %s '%s' %s", level, message, Arrays.asList(args));
    }

    private String rawMessageFor(String format, Object ... args) {
        return String.format("'%s' %s", format, Arrays.asList(args));
    }
}

