/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import com.proofpoint.log.Logger;
import com.proofpoint.log.LoggingConfiguration;
import com.proofpoint.log.LoggingOutputStream;
import com.proofpoint.log.NonCloseableOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Logging {
    private static final String PATTERN = "%d{yyyy-MM-dd'T'HH:mm:ss.SSSZ}\\t%5p\\t%t\\t%c\\t%m%n";
    private final LoggerContext context;
    private final ch.qos.logback.classic.Logger root;
    private final Logger log = Logger.get(Logging.class);
    private OutputStreamAppender<ILoggingEvent> consoleAppender;
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final OutputStream stderr = new NonCloseableOutputStream(System.err);

    public Logging() {
        this.root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        this.context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.context.reset();
        this.root.setLevel(Level.INFO);
        this.rewireStdStreams();
        this.redirectJULToSLF4j();
    }

    private void rewireStdStreams() {
        this.redirectSlf4jTo(stderr);
        this.log.info("Logging to stderr", new Object[0]);
        this.redirectStdStreamsToSlf4j();
    }

    private void redirectStdStreamsToSlf4j() {
        System.setOut(new PrintStream(new LoggingOutputStream(LoggerFactory.getLogger((String)"stdout")), true));
        System.setErr(new PrintStream(new LoggingOutputStream(LoggerFactory.getLogger((String)"stderr")), true));
    }

    private void redirectSlf4jTo(OutputStream stream) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(PATTERN);
        encoder.setContext((Context)this.context);
        encoder.start();
        this.consoleAppender = new OutputStreamAppender();
        this.consoleAppender.setContext((Context)this.context);
        this.consoleAppender.setEncoder((Encoder)encoder);
        this.consoleAppender.setOutputStream(stream);
        this.consoleAppender.start();
        this.root.addAppender(this.consoleAppender);
    }

    public void disableConsole() {
        this.log.info("Disabling stderr output", new Object[0]);
        this.root.detachAppender(this.consoleAppender);
        this.consoleAppender.stop();
    }

    public void logToFile(String logPath, int maxHistory, long maxSizeInBytes) {
        this.log.info("Logging to %s", logPath);
        this.recoverTempFiles(logPath);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(PATTERN);
        encoder.setContext((Context)this.context);
        encoder.start();
        RollingFileAppender fileAppender = new RollingFileAppender();
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        rollingPolicy.setContext((Context)this.context);
        rollingPolicy.setFileNamePattern(logPath + "-%d{yyyy-MM-dd}.%i.log.gz");
        rollingPolicy.setMaxHistory(maxHistory);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
        rollingPolicy.setParent((FileAppender)fileAppender);
        rollingPolicy.start();
        triggeringPolicy.setMaxFileSize(Long.toString(maxSizeInBytes));
        triggeringPolicy.setContext((Context)this.context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        triggeringPolicy.start();
        fileAppender.setFile(logPath);
        fileAppender.setAppend(true);
        fileAppender.setEncoder((Encoder)encoder);
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        fileAppender.setContext((Context)this.context);
        fileAppender.start();
        this.root.addAppender((Appender)fileAppender);
    }

    private void redirectJULToSLF4j() {
        java.util.logging.Logger javaRootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : javaRootLogger.getHandlers()) {
            javaRootLogger.removeHandler(handler);
        }
        javaRootLogger.addHandler((Handler)new SLF4JBridgeHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevels(File file) throws IOException {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(file);){
            properties.load(reader);
        }
        this.processLevels(properties);
    }

    private void processLevels(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)name);
            logger.setLevel(Level.toLevel((String)entry.getValue().toString()));
        }
    }

    private void recoverTempFiles(String logPath) {
        File logPathFile = new File(logPath).getParentFile();
        File[] tempFiles = logPathFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(Logging.TEMP_FILE_EXTENSION);
            }
        });
        if (tempFiles != null) {
            for (File tempFile : tempFiles) {
                String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
                File newFile = new File(tempFile.getParent(), newName + LOG_FILE_EXTENSION);
                if (tempFile.renameTo(newFile)) {
                    this.log.info("Recovered temp file: %s", tempFile);
                    continue;
                }
                this.log.warn("Could not rename temp file [%s] to [%s]", tempFile, newFile);
            }
        }
    }

    public void initialize(LoggingConfiguration config) throws IOException {
        if (config.getLogPath() == null && !config.isConsoleEnabled()) {
            throw new IllegalArgumentException("No log file is configured (log.output-file) and logging to console is disabled (log.enable-console)");
        }
        if (config.getLogPath() != null) {
            this.logToFile(config.getLogPath(), config.getMaxHistory(), config.getMaxSegmentSizeInBytes());
        }
        for (Status status : this.root.getLoggerContext().getStatusManager().getCopyOfStatusList()) {
            if (status.getLevel() != 2) continue;
            this.log.error(status.getMessage(), new Object[0]);
        }
        StatusChecker checker = new StatusChecker((Context)this.root.getLoggerContext());
        if (checker.getHighestLevel(0L) == 2) {
            throw new RuntimeException("Error initializing logger, aborting");
        }
        if (!config.isConsoleEnabled()) {
            this.disableConsole();
        }
        if (config.getLevelsFile() != null) {
            this.setLevels(new File(config.getLevelsFile()));
        }
    }
}

