/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.LegacyConfig;
import com.proofpoint.units.DataSize;

public class LoggingConfiguration {
    private boolean consoleEnabled = true;
    private String logPath = null;
    private DataSize maxSegmentSize = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private int maxHistory = 30;
    private String levelsFile = null;

    public boolean isConsoleEnabled() {
        return this.consoleEnabled;
    }

    @Config(value="log.enable-console")
    public LoggingConfiguration setConsoleEnabled(boolean consoleEnabled) {
        this.consoleEnabled = consoleEnabled;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="log.output-file")
    public LoggingConfiguration setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public DataSize getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    @Config(value="log.max-size")
    public LoggingConfiguration setMaxSegmentSize(DataSize maxSegmentSize) {
        this.maxSegmentSize = maxSegmentSize;
        return this;
    }

    @LegacyConfig(value={"log.max-size-in-bytes"}, replacedBy="log.max-size")
    public LoggingConfiguration setMaxSegmentSizeInBytes(long maxSegmentSizeInBytes) {
        this.maxSegmentSize = new DataSize((double)maxSegmentSizeInBytes, DataSize.Unit.BYTE);
        return this;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    @Config(value="log.max-history")
    public LoggingConfiguration setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        return this;
    }

    public String getLevelsFile() {
        return this.levelsFile;
    }

    @Config(value="log.levels-file")
    public LoggingConfiguration setLevelsFile(String levelsFile) {
        this.levelsFile = levelsFile;
        return this;
    }
}

