/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.Managed;

public class LoggingMBean {
    @Managed
    public String getLevel(String loggerName) {
        return LoggingMBean.getLogger(loggerName).getEffectiveLevel().toString();
    }

    @Managed
    public void setLevel(String loggerName, String newLevel) {
        LoggingMBean.getLogger(loggerName).setLevel(Level.toLevel((String)newLevel));
    }

    @Managed
    public String getRootLevel() {
        return LoggingMBean.getLogger("ROOT").getEffectiveLevel().toString();
    }

    @Managed
    public void setRootLevel(String newLevel) {
        LoggingMBean.getLogger("ROOT").setLevel(Level.toLevel((String)newLevel));
    }

    @Managed
    public Map<String, String> getAllLevels() {
        TreeMap levels = Maps.newTreeMap();
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger logger : context.getLoggerList()) {
            if (logger.getLevel() == null) continue;
            levels.put(logger.getName(), logger.getLevel().toString());
        }
        return levels;
    }

    private static Logger getLogger(String name) {
        return (Logger)LoggerFactory.getLogger((String)name);
    }
}

