/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import com.proofpoint.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class LoggingOutputStream
extends ByteArrayOutputStream {
    private final String lineSeparator;
    private final Logger logger;

    public LoggingOutputStream(Logger logger) {
        this.logger = logger;
        this.lineSeparator = System.getProperty("line.separator");
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        String record = this.toString("UTF-8");
        this.reset();
        if (record.isEmpty() || record.equals(this.lineSeparator)) {
            return;
        }
        this.logger.info("%s", record);
    }
}

