/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import com.proofpoint.log.StaticFormatter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

final class OutputStreamHandler
extends Handler {
    private final StaticFormatter formatter = new StaticFormatter();
    private final AtomicBoolean reported = new AtomicBoolean();
    private final Writer writer;

    public OutputStreamHandler(OutputStream out) {
        this.writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    @Override
    public void publish(LogRecord record) {
        block3: {
            if (!this.isLoggable(record)) {
                return;
            }
            try {
                this.writer.write(this.formatter.format(record));
                this.writer.flush();
            }
            catch (Exception e) {
                if (this.reported.getAndSet(true)) break block3;
                PrintWriter error = new PrintWriter(this.writer);
                error.print("LOGGING FAILED: ");
                e.printStackTrace(error);
                error.flush();
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

