/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.EncoderBase;
import com.proofpoint.log.Logging;
import com.proofpoint.log.StaticFormatter;
import com.proofpoint.units.DataSize;
import java.nio.charset.StandardCharsets;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

final class RollingFileHandler
extends Handler {
    private final Appender<String> fileAppender;

    RollingFileHandler(String filename, int maxHistory, DataSize maxFileSize, DataSize maxTotalSize) {
        this.setFormatter(new StaticFormatter());
        this.fileAppender = Logging.createFileAppender(filename, maxHistory, maxFileSize, maxTotalSize, new StringEncoder(), (Context)new ContextBase());
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            message = this.getFormatter().format(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            this.fileAppender.doAppend((Object)message);
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        try {
            this.fileAppender.stop();
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
    }

    private static final class StringEncoder
    extends EncoderBase<String> {
        private StringEncoder() {
        }

        public byte[] headerBytes() {
            return null;
        }

        public byte[] encode(String event) {
            return event.getBytes(StandardCharsets.UTF_8);
        }

        public byte[] footerBytes() {
            return null;
        }
    }
}

