/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.node;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.proofpoint.node.ApplicationName;
import com.proofpoint.node.NodeConfig;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.weakref.jmx.Managed;

@Singleton
public class NodeInfo {
    private static final Pattern HOST_EXCEPTION_MESSAGE_PATTERN = Pattern.compile("([-_a-zA-Z0-9]+):.*");
    private final String application;
    private final String environment;
    private final String pool;
    private final String nodeId;
    private final String location;
    private final String binarySpec;
    private final String configSpec;
    private final String instanceId = UUID.randomUUID().toString();
    private final InetAddress internalIp;
    private final String internalHostname;
    private final String externalAddress;
    private final InetAddress bindIp;
    private final long startTime = System.currentTimeMillis();

    public NodeInfo(String environment) {
        this("test-application", new NodeConfig().setEnvironment(environment));
    }

    @Inject
    public NodeInfo(@ApplicationName String application, NodeConfig config) {
        this(application, config.getEnvironment(), config.getPool(), config.getNodeId(), config.getNodeInternalIp(), config.getNodeInternalHostname(), config.getNodeBindIp(), config.getNodeExternalAddress(), config.getLocation(), config.getBinarySpec(), config.getConfigSpec());
    }

    public NodeInfo(String application, String environment, String pool, String nodeId, InetAddress internalIp, String internalHostname, InetAddress bindIp, String externalAddress, String location, String binarySpec, String configSpec) {
        Preconditions.checkNotNull((Object)application, (Object)"application is null");
        Preconditions.checkNotNull((Object)environment, (Object)"environment is null");
        Preconditions.checkNotNull((Object)pool, (Object)"pool is null");
        Preconditions.checkArgument((boolean)environment.matches("[a-z0-9][_a-z0-9]*"), (String)"environment '%s' is invalid", (Object[])new Object[]{environment});
        Preconditions.checkArgument((boolean)pool.matches("[a-zA-Z0-9][_a-zA-Z0-9]*"), (String)"pool '%s' is invalid", (Object[])new Object[]{pool});
        this.application = application;
        this.environment = environment;
        this.pool = pool;
        if (nodeId != null) {
            Preconditions.checkArgument((boolean)nodeId.matches("[A-Za-z0-9][_A-Za-z0-9-]*"), (String)"nodeId '%s' is invalid", (Object[])new Object[]{nodeId});
            this.nodeId = nodeId;
        } else {
            this.nodeId = UUID.randomUUID().toString();
        }
        this.location = location != null ? location : "/" + this.nodeId;
        this.binarySpec = binarySpec;
        this.configSpec = configSpec;
        this.internalIp = internalIp != null ? internalIp : NodeInfo.findPublicIp();
        if (internalHostname != null) {
            Preconditions.checkArgument((internalHostname.equals("localhost") || internalHostname.matches("[a-z0-9][_a-z0-9]*(?:\\.[a-z0-9][_a-z0-9]*)+") ? 1 : 0) != 0, (Object)String.format("hostname '%s' is invalid", internalHostname));
            this.internalHostname = internalHostname;
        } else {
            this.internalHostname = this.findPublicHostname();
        }
        this.bindIp = bindIp != null ? bindIp : InetAddresses.fromInteger((int)0);
        this.externalAddress = externalAddress != null ? externalAddress : InetAddresses.toAddrString((InetAddress)this.internalIp);
    }

    @Managed
    public String getApplication() {
        return this.application;
    }

    @Managed
    public String getEnvironment() {
        return this.environment;
    }

    @Managed
    public String getPool() {
        return this.pool;
    }

    @Managed
    public String getNodeId() {
        return this.nodeId;
    }

    @Managed
    public String getLocation() {
        return this.location;
    }

    @Managed
    public String getBinarySpec() {
        return this.binarySpec;
    }

    @Managed
    public String getConfigSpec() {
        return this.configSpec;
    }

    @Managed
    public String getInstanceId() {
        return this.instanceId;
    }

    @Managed
    public InetAddress getInternalIp() {
        return this.internalIp;
    }

    @Managed
    public String getInternalHostname() {
        return this.internalHostname;
    }

    @Managed
    public String getExternalAddress() {
        return this.externalAddress;
    }

    @Managed
    public InetAddress getBindIp() {
        return this.bindIp;
    }

    @Managed
    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("nodeId", (Object)this.nodeId).add("instanceId", (Object)this.instanceId).add("internalIp", (Object)this.internalIp).add("externalAddress", (Object)this.externalAddress).add("bindIp", (Object)this.bindIp).add("startTime", this.startTime).toString();
    }

    private static InetAddress findPublicIp() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (NodeInfo.isGoodV4Address(localAddress)) {
                return localAddress;
            }
        }
        catch (UnknownHostException ignored) {
            // empty catch block
        }
        if (localAddress == null) {
            try {
                localAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)"Could not get local ip address");
            }
        }
        for (NetworkInterface networkInterface : NodeInfo.getGoodNetworkInterfaces()) {
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (!NodeInfo.isGoodV4Address(address)) continue;
                return address;
            }
        }
        for (NetworkInterface networkInterface : NodeInfo.getGoodNetworkInterfaces()) {
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (!NodeInfo.isGoodV6Address(address)) continue;
                return address;
            }
        }
        return localAddress;
    }

    private static List<NetworkInterface> getGoodNetworkInterfaces() {
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                try {
                    if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                    builder.add((Object)networkInterface);
                }
                catch (Exception exception) {}
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return builder.build();
    }

    private static boolean isGoodV4Address(InetAddress address) {
        return address instanceof Inet4Address && !address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }

    private static boolean isGoodV6Address(InetAddress address) {
        return address instanceof Inet6Address && !address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }

    private String findPublicHostname() {
        try {
            return InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            Matcher matcher = HOST_EXCEPTION_MESSAGE_PATTERN.matcher(e.getMessage());
            if (matcher.matches()) {
                return matcher.group(1).toLowerCase();
            }
            return InetAddresses.toUriString((InetAddress)this.internalIp);
        }
    }
}

