/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import java.io.IOException;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class AdminFilter
implements Filter {
    private static final String ADMIN_PATH = "/admin";
    private static final String ADMIN_PATH_PREFIX = "/admin/";
    private static final Predicate<String> IS_ADMIN_PATH_PREDICATE = input -> {
        if (input == null) {
            return false;
        }
        return input.equals(ADMIN_PATH) || input.startsWith(ADMIN_PATH_PREFIX);
    };
    private final Predicate<String> forThisPortPredicate;

    AdminFilter(boolean isAdmin) {
        this.forThisPortPredicate = isAdmin ? IS_ADMIN_PATH_PREDICATE : IS_ADMIN_PATH_PREDICATE.negate();
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String path = request.getPathInfo();
        if (this.forThisPortPredicate.test(path)) {
            chain.doFilter(servletRequest, servletResponse);
        } else {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.sendError(404);
        }
    }

    public void destroy() {
    }
}

