/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.proofpoint.units.Duration;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;

public class AsyncResponseHandler {
    private final AsyncResponse asyncResponse;
    private final WeakReference<CompletableFuture<?>> futureResponseReference;

    private AsyncResponseHandler(AsyncResponse asyncResponse, CompletableFuture<?> futureResponse) {
        this.asyncResponse = Objects.requireNonNull(asyncResponse, "asyncResponse is null");
        this.futureResponseReference = new WeakReference(Objects.requireNonNull(futureResponse, "futureResponse is null"));
    }

    public static AsyncResponseHandler bindAsyncResponse(AsyncResponse asyncResponse, CompletableFuture<?> futureResponse, Executor httpResponseExecutor) {
        futureResponse.whenCompleteAsync(AsyncResponseHandler.toCompletionCallback(asyncResponse), httpResponseExecutor);
        return new AsyncResponseHandler(asyncResponse, futureResponse);
    }

    public AsyncResponseHandler withTimeout(Duration timeout) {
        return this.withTimeout(timeout, Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)("Timed out after waiting for " + timeout.convertToMostSuccinctTimeUnit())).build());
    }

    public AsyncResponseHandler withTimeout(Duration timeout, Response timeoutResponse) {
        return this.withTimeout(timeout, (Supplier<Response>)Suppliers.ofInstance((Object)timeoutResponse));
    }

    public AsyncResponseHandler withTimeout(Duration timeout, Supplier<Response> timeoutResponse) {
        this.asyncResponse.setTimeoutHandler(asyncResponse -> {
            asyncResponse.resume(timeoutResponse.get());
            this.cancelFuture();
        });
        this.asyncResponse.setTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    private void cancelFuture() {
        CompletableFuture futureResponse = (CompletableFuture)this.futureResponseReference.get();
        if (futureResponse != null) {
            try {
                futureResponse.cancel(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static <T> BiConsumer<T, Throwable> toCompletionCallback(AsyncResponse asyncResponse) {
        return (value, throwable) -> {
            if (throwable != null) {
                asyncResponse.resume(throwable);
            } else {
                Preconditions.checkArgument((!(value instanceof Response.ResponseBuilder) ? 1 : 0) != 0, (Object)"Value is a ResponseBuilder. Did you forget to call build?");
                asyncResponse.resume(value);
            }
        };
    }
}

