/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.collect.ImmutableSet;
import com.proofpoint.http.server.Inet4Network;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CidrSet {
    private final Set<Inet4Network> cidrs;

    private CidrSet(Collection<Inet4Network> cidrs) {
        this.cidrs = ImmutableSet.copyOf(cidrs);
    }

    public static CidrSet fromString(String cidrList) {
        Set uris = (Set)Arrays.stream(cidrList.split("\\s*,\\s*")).map(Inet4Network::fromCidr).collect(ImmutableSet.toImmutableSet());
        return new CidrSet(uris);
    }

    public static CidrSet empty() {
        return new CidrSet((Collection<Inet4Network>)ImmutableSet.of());
    }

    public boolean containsAddress(InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            return false;
        }
        Inet4Address inet4Address = (Inet4Address)address;
        for (Inet4Network cidr : this.cidrs) {
            if (!cidr.containsAddress(inet4Address)) continue;
            return true;
        }
        return false;
    }

    public CidrSet union(CidrSet other) {
        return new CidrSet((Collection<Inet4Network>)ImmutableSet.builder().addAll(this.cidrs).addAll(other.cidrs).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrSet cidrSet = (CidrSet)o;
        return Objects.equals(this.cidrs, cidrSet.cidrs);
    }

    public int hashCode() {
        return Objects.hash(this.cidrs);
    }

    public String toString() {
        return this.cidrs.stream().map(Inet4Network::toString).collect(Collectors.joining(","));
    }
}

