/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ClassPathResourceHandler
extends AbstractHandler {
    private static final MimeTypes MIME_TYPES = new MimeTypes();
    private final String baseUri;
    private final String classPathResourceBase;
    private final List<String> welcomeFiles;

    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, String ... welcomeFiles) {
        this(baseUri, classPathResourceBase, (List<String>)ImmutableList.copyOf((Object[])welcomeFiles));
    }

    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, List<String> welcomeFiles) {
        Objects.requireNonNull(baseUri, "baseUri is null");
        Objects.requireNonNull(classPathResourceBase, "classPathResourceBase is null");
        Objects.requireNonNull(welcomeFiles, "welcomeFiles is null");
        baseUri = baseUri.startsWith("/") ? baseUri : '/' + baseUri;
        this.baseUri = baseUri = baseUri.endsWith("/") ? baseUri.substring(baseUri.length() - 1) : baseUri;
        this.classPathResourceBase = classPathResourceBase;
        ImmutableList.Builder files = ImmutableList.builder();
        for (String welcomeFile : welcomeFiles) {
            if (!welcomeFile.startsWith("/")) {
                welcomeFile = "/" + welcomeFile;
            }
            files.add((Object)welcomeFile);
        }
        this.welcomeFiles = files.build();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (baseRequest.isHandled()) {
            return;
        }
        URL resource = this.getResourcePath(request);
        if (resource == null) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request.getMethod();
        boolean skipContent = false;
        if (!HttpMethod.GET.is(method)) {
            if (HttpMethod.HEAD.is(method)) {
                skipContent = true;
            } else {
                response.sendError(405);
                return;
            }
        }
        try (InputStream resourceStream = resource.openStream();){
            ServletOutputStream out;
            String contentType = MIME_TYPES.getMimeByExtension(resource.toString());
            response.setContentType(contentType);
            if (skipContent) {
                return;
            }
            try {
                out = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                out = new WriterOutputStream((Writer)response.getWriter());
            }
            ByteStreams.copy((InputStream)resourceStream, (OutputStream)out);
        }
    }

    private URL getResourcePath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || !pathInfo.startsWith(this.baseUri)) {
            return null;
        }
        if (!this.baseUri.equals("/")) {
            pathInfo = pathInfo.substring(this.baseUri.length());
        }
        if (!pathInfo.startsWith("/") && !pathInfo.isEmpty()) {
            return null;
        }
        if (!pathInfo.startsWith("/")) {
            pathInfo = "/";
        }
        if (!"/".equals(pathInfo)) {
            String resourcePath = this.classPathResourceBase + pathInfo;
            return ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
        }
        for (String welcomeFile : this.welcomeFiles) {
            String resourcePath = this.classPathResourceBase + welcomeFile;
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    static {
        MIME_TYPES.addMimeMapping("json", "application/json");
    }
}

