/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.proofpoint.http.server.CidrSet;
import com.proofpoint.http.server.InternalNetworkConfig;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class ClientAddressExtractor {
    private static final CidrSet PRIVATE_NETWORKS = CidrSet.fromString("127.0.0.0/8,169.254.0.0/16,192.168.0.0/16,172.16.0.0/12,10.0.0.0/8");
    private final CidrSet trustedNetworks;

    public ClientAddressExtractor() {
        this.trustedNetworks = PRIVATE_NETWORKS;
    }

    @Inject
    public ClientAddressExtractor(InternalNetworkConfig config) {
        this.trustedNetworks = PRIVATE_NETWORKS.union(config.getInternalNetworks());
    }

    public String clientAddressFor(HttpServletRequest request) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Enumeration e = request.getHeaders("X-FORWARDED-FOR");
        while (e != null && e.hasMoreElements()) {
            String forwardedFor = (String)e.nextElement();
            builder.addAll(Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)forwardedFor));
        }
        if (request.getRemoteAddr() != null) {
            builder.add((Object)request.getRemoteAddr());
        }
        String clientAddress = null;
        ImmutableList clientAddresses = builder.build();
        for (String address : Lists.reverse((List)clientAddresses)) {
            try {
                if (!this.trustedNetworks.containsAddress(InetAddresses.forString((String)address))) {
                    clientAddress = address;
                    break;
                }
                clientAddress = address;
            }
            catch (IllegalArgumentException ignored) {
                break;
            }
        }
        if (clientAddress == null) {
            clientAddress = request.getRemoteAddr();
        }
        return clientAddress;
    }
}

