/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import com.proofpoint.http.server.HttpRequestEvent;
import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.http.server.RequestLog;
import com.proofpoint.log.Logging;
import com.proofpoint.units.DataSize;
import com.proofpoint.units.Duration;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

class DelimitedRequestLog
implements RequestLog {
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
    private final Appender<HttpRequestEvent> appender;

    DelimitedRequestLog(HttpServerConfig config) {
        this.appender = Logging.createFileAppender((String)config.getLogPath(), (int)config.getLogMaxHistory(), (int)config.getLogQueueSize(), (Duration)new Duration(10.0, TimeUnit.SECONDS), (DataSize)config.getLogMaxSegmentSize(), (DataSize)config.getLogMaxTotalSize(), (Encoder)new EventEncoder(), (Context)new ContextBase());
    }

    @Override
    public void log(HttpRequestEvent event) {
        this.appender.doAppend((Object)event);
    }

    @Override
    public void stop() {
        this.appender.stop();
    }

    private static class EventEncoder
    extends EncoderBase<HttpRequestEvent> {
        private EventEncoder() {
        }

        public byte[] headerBytes() {
            return null;
        }

        public byte[] encode(HttpRequestEvent event) {
            StringBuilder builder = new StringBuilder();
            builder.append(ISO_FORMATTER.format(event.getTimeStamp())).append('\t').append(event.getClientAddress()).append('\t').append(event.getMethod()).append('\t').append(event.getRequestUri()).append('\t').append(event.getUser()).append('\t').append(event.getAgent()).append('\t').append(event.getResponseCode()).append('\t').append(event.getRequestSize()).append('\t').append(event.getResponseSize()).append('\t').append(event.getTimeToLastByte()).append('\t').append(event.getTraceToken()).append('\n');
            return builder.toString().getBytes(StandardCharsets.UTF_8);
        }

        public byte[] footerBytes() {
            return null;
        }
    }
}

