/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.base.Ascii;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class GZipRequestWrapper
extends HttpServletRequestWrapper {
    private final HttpServletRequest request;

    GZipRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamFromInputStream(new GZIPInputStream((InputStream)this.request.getInputStream()));
    }

    public int getContentLength() {
        return -1;
    }

    public String getHeader(String name) {
        if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"content-length") || Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"content-encoding")) {
            return null;
        }
        return this.request.getHeader(name);
    }

    public int getIntHeader(String name) {
        if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"content-length")) {
            return -1;
        }
        return this.request.getIntHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return new FilteringEnumeration(this.request.getHeaderNames());
    }

    public Enumeration<String> getHeaders(String name) {
        if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"content-length") || Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"content-encoding")) {
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public String nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
        return this.request.getHeaders(name);
    }

    private static class FilteringEnumeration
    implements Enumeration<String> {
        private final Enumeration<String> delegate;
        MoreElementsState moreElementsState;
        String nextElement;

        public FilteringEnumeration(Enumeration<String> headerNames) {
            this.delegate = headerNames;
            this.moreElementsState = MoreElementsState.UNKNOWN;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.moreElementsState == MoreElementsState.UNKNOWN) {
                this.lookAhead();
            }
            return this.moreElementsState == MoreElementsState.YES;
        }

        @Override
        public String nextElement() {
            if (this.moreElementsState == MoreElementsState.UNKNOWN) {
                this.lookAhead();
            }
            if (this.moreElementsState == MoreElementsState.NO) {
                throw new NoSuchElementException();
            }
            this.moreElementsState = MoreElementsState.UNKNOWN;
            return this.nextElement;
        }

        private void lookAhead() {
            do {
                if (!this.delegate.hasMoreElements()) {
                    this.moreElementsState = MoreElementsState.NO;
                    return;
                }
                this.nextElement = this.delegate.nextElement();
            } while (Ascii.equalsIgnoreCase((CharSequence)this.nextElement, (CharSequence)"content-length") || Ascii.equalsIgnoreCase((CharSequence)this.nextElement, (CharSequence)"content-encoding"));
            this.moreElementsState = MoreElementsState.YES;
        }

        private static enum MoreElementsState {
            UNKNOWN,
            YES,
            NO;

        }
    }

    private static class ServletInputStreamFromInputStream
    extends ServletInputStream {
        private final InputStream stream;

        ServletInputStreamFromInputStream(InputStream stream) {
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        public void reset() throws IOException {
            this.stream.reset();
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public boolean isFinished() {
            throw new UnsupportedOperationException();
        }

        public boolean isReady() {
            throw new UnsupportedOperationException();
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }
    }
}

