/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.proofpoint.http.server.ClientAddressExtractor;
import com.proofpoint.http.server.DoubleSummaryStats;
import com.proofpoint.tracetoken.TraceTokenManager;
import com.proofpoint.units.Duration;
import java.security.Principal;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

@JsonPropertyOrder(value={"time", "traceToken", "sourceIp", "method", "requestUri", "username", "userAgent", "responseCode", "requestSize", "responseSize", "protocolVersion", "tlsProtocolVersion", "tlsCipherSuite", "timeToDispatch", "timeToRequestEnd", "timeResponseContent", "responseContentChunk", "timeToLastByte"})
class HttpRequestEvent {
    private final Instant timeStamp;
    private final String traceToken;
    private final String clientAddress;
    private final String method;
    private final String requestUri;
    private final String user;
    private final String agent;
    private final long requestSize;
    private final long responseSize;
    private final int responseCode;
    private final long timeToLastByte;
    private final long beginToDispatchMillis;
    private final long beginToEndMillis;
    private final long firstToLastContentTimeInMillis;
    private final DoubleSummaryStats responseContentInterarrivalStats;
    private final String protocolVersion;
    private final String tlsProtocolVersion;
    private final String tlsCipherSuite;

    static HttpRequestEvent createHttpRequestEvent(Request request, Response response, @Nullable SSLSession sslSession, long currentTimeInMillis, long beginToDispatchMillis, long beginToEndMillis, long firstToLastContentTimeInMillis, @Nullable DoubleSummaryStats responseContentInterarrivalStats, ClientAddressExtractor clientAddressExtractor) {
        String method;
        String user = null;
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            user = principal.getName();
        }
        String token = TraceTokenManager.getCurrentRequestToken();
        long timeToLastByte = Math.max(currentTimeInMillis - request.getTimeStamp(), 0L);
        String requestUri = null;
        if (request.getHttpURI() != null) {
            requestUri = request.getHttpURI().getPathQuery();
        }
        if ((method = request.getMethod()) != null) {
            method = method.toUpperCase();
        }
        return new HttpRequestEvent(Instant.ofEpochMilli(request.getTimeStamp()), token, clientAddressExtractor.clientAddressFor((HttpServletRequest)request), method, requestUri, user, request.getHeader("User-Agent"), request.getContentRead(), response.getContentCount(), response.getStatus(), timeToLastByte, beginToDispatchMillis, beginToEndMillis, firstToLastContentTimeInMillis, responseContentInterarrivalStats, request.getHttpVersion().toString(), sslSession == null ? null : sslSession.getProtocol(), sslSession == null ? null : sslSession.getCipherSuite());
    }

    private HttpRequestEvent(Instant timeStamp, String traceToken, String clientAddress, String method, String requestUri, String user, String agent, long requestSize, long responseSize, int responseCode, long timeToLastByte, long beginToDispatchMillis, long beginToEndMillis, long firstToLastContentTimeInMillis, DoubleSummaryStats responseContentInterarrivalStats, String protocolVersion, String tlsProtocolVersion, String tlsCipherSuite) {
        this.timeStamp = timeStamp;
        this.traceToken = traceToken;
        this.clientAddress = clientAddress;
        this.method = method;
        this.requestUri = requestUri;
        this.user = user;
        this.agent = agent;
        this.requestSize = requestSize;
        this.responseSize = responseSize;
        this.responseCode = responseCode;
        this.timeToLastByte = timeToLastByte;
        this.beginToDispatchMillis = beginToDispatchMillis;
        this.beginToEndMillis = beginToEndMillis;
        this.firstToLastContentTimeInMillis = firstToLastContentTimeInMillis;
        this.responseContentInterarrivalStats = responseContentInterarrivalStats;
        this.protocolVersion = protocolVersion;
        this.tlsProtocolVersion = tlsProtocolVersion;
        this.tlsCipherSuite = tlsCipherSuite;
    }

    @JsonProperty(value="time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    @JsonProperty
    public String getTraceToken() {
        return this.traceToken;
    }

    @JsonProperty(value="sourceIp")
    public String getClientAddress() {
        return this.clientAddress;
    }

    @JsonProperty
    public String getMethod() {
        return this.method;
    }

    @JsonProperty
    public String getRequestUri() {
        return this.requestUri;
    }

    @JsonProperty(value="username")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="userAgent")
    public String getAgent() {
        return this.agent;
    }

    @JsonProperty
    public long getRequestSize() {
        return this.requestSize;
    }

    @JsonProperty
    public long getResponseSize() {
        return this.responseSize;
    }

    @JsonProperty
    public int getResponseCode() {
        return this.responseCode;
    }

    public long getTimeToLastByte() {
        return this.timeToLastByte;
    }

    @JsonProperty(value="timeToLastByte")
    public Duration getTimeToLastByteDuration() {
        return new Duration((double)this.timeToLastByte, TimeUnit.MILLISECONDS);
    }

    @JsonProperty
    public Duration getTimeToDispatch() {
        return new Duration((double)this.beginToDispatchMillis, TimeUnit.MILLISECONDS);
    }

    @JsonProperty
    public Duration getTimeToRequestEnd() {
        return new Duration((double)this.beginToEndMillis, TimeUnit.MILLISECONDS);
    }

    @Nullable
    @JsonProperty
    public Duration getTimeResponseContent() {
        if (this.firstToLastContentTimeInMillis < 0L) {
            return null;
        }
        return new Duration((double)this.firstToLastContentTimeInMillis, TimeUnit.MILLISECONDS);
    }

    @Nullable
    @JsonProperty
    public DoubleSummaryStats getResponseContentChunk() {
        return this.responseContentInterarrivalStats;
    }

    @JsonProperty
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @JsonProperty
    public String getTlsProtocolVersion() {
        return this.tlsProtocolVersion;
    }

    @JsonProperty
    public String getTlsCipherSuite() {
        return this.tlsCipherSuite;
    }
}

