/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.proofpoint.bootstrap.AcceptRequests;
import com.proofpoint.http.server.AdminFilter;
import com.proofpoint.http.server.ClassPathResourceHandler;
import com.proofpoint.http.server.ClientAddressExtractor;
import com.proofpoint.http.server.DetailedRequestStats;
import com.proofpoint.http.server.GZipRequestFilter;
import com.proofpoint.http.server.HttpServerBinder;
import com.proofpoint.http.server.HttpServerChannelListener;
import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.http.server.HttpServerInfo;
import com.proofpoint.http.server.QueryStringFilter;
import com.proofpoint.http.server.RequestLog;
import com.proofpoint.http.server.RequestStats;
import com.proofpoint.http.server.StatsRecordingHandler;
import com.proofpoint.http.server.TimingFilter;
import com.proofpoint.http.server.TraceTokenFilter;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.stats.MaxGauge;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpServer {
    private static final String[] ENABLED_PROTOCOLS;
    private static final String[] ENABLED_CIPHERS;
    private final Server server;
    private final boolean registerErrorHandler;
    private final RequestStats stats;
    private final MaxGauge busyThreads = new MaxGauge();
    private final RequestLog requestLog;
    private final ClientAddressExtractor clientAddressExtractor;
    private final Optional<ZonedDateTime> certificateExpiration;

    @Deprecated
    public HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, @Nullable Servlet theAdminServlet, @Nullable Map<String, String> adminParameters, @Nullable Set<Filter> adminFilters, @Nullable MBeanServer mbeanServer, @Nullable LoginService loginService, QueryStringFilter queryStringFilter, RequestStats stats, DetailedRequestStats detailedRequestStats, @Nullable RequestLogHandler logHandler) throws IOException {
        this(httpServerInfo, nodeInfo, config, theServlet, parameters, filters, resources, theAdminServlet, adminParameters, adminFilters, mbeanServer, loginService, queryStringFilter, stats, detailedRequestStats, (RequestLog)null, new ClientAddressExtractor());
    }

    @Deprecated
    public HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, @Nullable Servlet theAdminServlet, @Nullable Map<String, String> adminParameters, @Nullable Set<Filter> adminFilters, @Nullable MBeanServer mbeanServer, @Nullable LoginService loginService, QueryStringFilter queryStringFilter, RequestStats stats, DetailedRequestStats detailedRequestStats, @Nullable RequestLogHandler logHandler, ClientAddressExtractor clientAddressExtractor) throws IOException {
        this(httpServerInfo, nodeInfo, config, theServlet, parameters, filters, resources, theAdminServlet, adminParameters, adminFilters, mbeanServer, loginService, queryStringFilter, stats, detailedRequestStats, (RequestLog)null, clientAddressExtractor);
    }

    HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, @Nullable Servlet theAdminServlet, @Nullable Map<String, String> adminParameters, @Nullable Set<Filter> adminFilters, @Nullable MBeanServer mbeanServer, @Nullable LoginService loginService, QueryStringFilter queryStringFilter, RequestStats stats, DetailedRequestStats detailedRequestStats, @Nullable RequestLog requestLog, ClientAddressExtractor clientAddressExtractor) throws IOException {
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(theServlet, "theServlet is null");
        Objects.requireNonNull(parameters, "parameters is null");
        Objects.requireNonNull(filters, "filters is null");
        Objects.requireNonNull(resources, "resources is null");
        Objects.requireNonNull(queryStringFilter, "queryStringFilter is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(detailedRequestStats, "detailedRequestStats is null");
        this.requestLog = requestLog;
        this.clientAddressExtractor = Objects.requireNonNull(clientAddressExtractor, "clientAddressExtractor is null");
        QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads()){

            protected void runJob(Runnable job) {
                try {
                    HttpServer.this.busyThreads.add(1);
                    super.runJob(job);
                }
                finally {
                    HttpServer.this.busyThreads.add(-1);
                }
            }
        };
        threadPool.setMinThreads(config.getMinThreads());
        threadPool.setIdleTimeout(Ints.checkedCast((long)config.getThreadMaxIdleTime().toMillis()));
        threadPool.setName("http-worker");
        this.server = new Server((ThreadPool)threadPool);
        this.server.setStopTimeout(config.getStopTimeout().toMillis());
        this.registerErrorHandler = config.isShowStackTrace();
        if (mbeanServer != null) {
            MBeanContainer mbeanContainer = new MBeanContainer(mbeanServer);
            this.server.addBean((Object)mbeanContainer);
        }
        HttpConfiguration baseHttpConfiguration = new HttpConfiguration();
        baseHttpConfiguration.setSendServerVersion(false);
        baseHttpConfiguration.setSendXPoweredBy(false);
        if (config.getMaxRequestHeaderSize() != null) {
            baseHttpConfiguration.setRequestHeaderSize(Math.toIntExact(config.getMaxRequestHeaderSize().toBytes()));
        }
        baseHttpConfiguration.setNotifyRemoteAsyncErrors(false);
        HttpServerChannelListener channelListener = null;
        if (requestLog != null) {
            channelListener = new HttpServerChannelListener(requestLog, clientAddressExtractor);
        }
        if (config.isHttpEnabled()) {
            HttpConfiguration httpConfiguration = new HttpConfiguration(baseHttpConfiguration);
            if (config.isHttpsEnabled()) {
                httpConfiguration.setSecureScheme("https");
                httpConfiguration.setSecurePort(httpServerInfo.getHttpsUri().getPort());
            }
            Integer acceptors = config.getHttpAcceptorThreads();
            Integer selectors = config.getHttpSelectorThreads();
            HttpConnectionFactory http1 = new HttpConnectionFactory(httpConfiguration);
            HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfiguration);
            http2c.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            http2c.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
            http2c.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            http2c.setStreamIdleTimeout(config.getHttp2StreamIdleTimeout().toMillis());
            ServerConnector httpConnector = HttpServer.createServerConnector(httpServerInfo.getHttpChannel(), this.server, null, (Integer)MoreObjects.firstNonNull((Object)acceptors, (Object)-1), (Integer)MoreObjects.firstNonNull((Object)selectors, (Object)-1), new ConnectionFactory[]{http1, http2c});
            httpConnector.setName("http");
            httpConnector.setPort(httpServerInfo.getHttpUri().getPort());
            httpConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            if (channelListener != null) {
                httpConnector.addBean((Object)channelListener);
            }
            this.server.addConnector((Connector)httpConnector);
        }
        if (config.isHttpsEnabled()) {
            HttpConfiguration httpsConfiguration = new HttpConfiguration(baseHttpConfiguration);
            Integer acceptors = config.getHttpsAcceptorThreads();
            Integer selectors = config.getHttpsSelectorThreads();
            ServerConnector httpsConnector = this.createHttpsServerConnector(config, httpServerInfo.getHttpsChannel(), httpsConfiguration, null, (Integer)MoreObjects.firstNonNull((Object)acceptors, (Object)-1), (Integer)MoreObjects.firstNonNull((Object)selectors, (Object)-1));
            httpsConnector.setName("https");
            httpsConnector.setPort(httpServerInfo.getHttpsUri().getPort());
            httpsConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpsConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpsConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            if (channelListener != null) {
                httpsConnector.addBean((Object)channelListener);
            }
            this.server.addConnector((Connector)httpsConnector);
        }
        if (config.isAdminEnabled()) {
            ServerConnector adminConnector;
            HttpConfiguration adminConfiguration = new HttpConfiguration(baseHttpConfiguration);
            QueuedThreadPool adminThreadPool = new QueuedThreadPool(config.getAdminMaxThreads());
            adminThreadPool.setName("http-admin-worker");
            adminThreadPool.setMinThreads(config.getAdminMinThreads());
            adminThreadPool.setIdleTimeout(Ints.checkedCast((long)config.getThreadMaxIdleTime().toMillis()));
            if (config.isHttpsEnabled()) {
                adminConnector = this.createHttpsServerConnector(config, httpServerInfo.getAdminChannel(), adminConfiguration, (Executor)adminThreadPool, 0, -1);
            } else {
                HttpConnectionFactory http1 = new HttpConnectionFactory(adminConfiguration);
                HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(adminConfiguration);
                http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
                adminConnector = HttpServer.createServerConnector(httpServerInfo.getAdminChannel(), this.server, (Executor)adminThreadPool, -1, -1, new ConnectionFactory[]{http1, http2c});
            }
            adminConnector.setName("admin");
            adminConnector.setPort(httpServerInfo.getAdminUri().getPort());
            adminConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            adminConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            adminConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            this.server.addConnector((Connector)adminConnector);
        }
        HandlerCollection handlers = new HandlerCollection();
        for (HttpServerBinder.HttpResourceBinding resource : resources) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setHandler((Handler)new ClassPathResourceHandler(resource.getBaseUri(), resource.getClassPathResourceBase(), resource.getWelcomeFiles()));
            handlers.addHandler((Handler)gzipHandler);
        }
        handlers.addHandler((Handler)this.createServletContext(theServlet, parameters, false, filters, queryStringFilter, loginService, nodeInfo, "http", "https"));
        RequestLogHandler statsRecorder = new RequestLogHandler();
        statsRecorder.setRequestLog((org.eclipse.jetty.server.RequestLog)new StatsRecordingHandler(stats, detailedRequestStats));
        handlers.addHandler((Handler)statsRecorder);
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        HandlerList rootHandlers = new HandlerList();
        if (theAdminServlet != null && config.isAdminEnabled()) {
            rootHandlers.addHandler((Handler)this.createServletContext(theAdminServlet, adminParameters, true, adminFilters, queryStringFilter, loginService, nodeInfo, "admin"));
        }
        rootHandlers.addHandler((Handler)statsHandler);
        this.server.setHandler((Handler)rootHandlers);
        this.certificateExpiration = HttpServer.loadAllX509Certificates(config).stream().map(X509Certificate::getNotAfter).min(Comparator.naturalOrder()).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    private ServerConnector createHttpsServerConnector(HttpServerConfig config, ServerSocketChannel serverSocketChannel, HttpConfiguration configuration, Executor threadPool, int acceptors, int selectors) throws IOException {
        boolean isJava8 = System.getProperty("java.version").startsWith("1.8.");
        configuration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        sslContextFactory.setKeyStorePath(config.getKeystorePath());
        sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
        sslContextFactory.setExcludeProtocols(new String[0]);
        sslContextFactory.setIncludeProtocols(ENABLED_PROTOCOLS);
        sslContextFactory.setExcludeCipherSuites(new String[0]);
        sslContextFactory.setIncludeCipherSuites(ENABLED_CIPHERS);
        sslContextFactory.setCipherComparator((Comparator)Ordering.explicit((Object)"", (Object[])ENABLED_CIPHERS));
        sslContextFactory.setSslSessionTimeout((int)config.getSslSessionTimeout().getValue(TimeUnit.SECONDS));
        sslContextFactory.setSslSessionCacheSize(config.getSslSessionCacheSize());
        ArrayList<Object> connectionFactories = new ArrayList<Object>();
        connectionFactories.add(new SslConnectionFactory(sslContextFactory, isJava8 ? "http/1.1" : "alpn"));
        if (!isJava8) {
            connectionFactories.add(new ALPNServerConnectionFactory(new String[]{"h2", "http/1.1"}));
            HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(configuration);
            http2.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            http2.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            http2.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
            http2.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            http2.setStreamIdleTimeout(config.getHttp2StreamIdleTimeout().toMillis());
            connectionFactories.add(http2);
        }
        connectionFactories.add(new HttpConnectionFactory(configuration));
        return HttpServer.createServerConnector(serverSocketChannel, this.server, threadPool, acceptors, selectors, connectionFactories.toArray(new ConnectionFactory[0]));
    }

    private ServletContextHandler createServletContext(Servlet theServlet, Map<String, String> parameters, boolean isAdmin, Set<Filter> filters, QueryStringFilter queryStringFilter, LoginService loginService, NodeInfo nodeInfo, String ... connectorNames) {
        ServletContextHandler context = new ServletContextHandler(0);
        if (!isAdmin) {
            context.addFilter(new FilterHolder((Filter)new AdminFilter(false)), "/*", null);
        }
        context.addFilter(new FilterHolder((Filter)new TimingFilter()), "/*", null);
        context.addFilter(new FilterHolder((Filter)queryStringFilter), "/*", null);
        context.addFilter(new FilterHolder((Filter)new TraceTokenFilter(nodeInfo.getInternalIp(), this.clientAddressExtractor)), "/*", null);
        context.setGzipHandler(new GzipHandler());
        context.addFilter(GZipRequestFilter.class, "/*", null);
        if (loginService != null) {
            SecurityHandler securityHandler = HttpServer.createSecurityHandler(loginService);
            context.setSecurityHandler(securityHandler);
        }
        for (Filter filter : filters) {
            context.addFilter(new FilterHolder(filter), "/*", null);
        }
        ServletHolder servletHolder = new ServletHolder(theServlet);
        servletHolder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
        context.addServlet(servletHolder, "/*");
        String[] virtualHosts = new String[connectorNames.length];
        for (int i = 0; i < connectorNames.length; ++i) {
            virtualHosts[i] = "@" + connectorNames[i];
        }
        context.setVirtualHosts(virtualHosts);
        return context;
    }

    private static SecurityHandler createSecurityHandler(LoginService loginService) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(false);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setConstraintMappings((List)ImmutableList.of((Object)constraintMapping));
        return securityHandler;
    }

    @Managed
    public Long getDaysUntilCertificateExpiration() {
        return this.certificateExpiration.map(date -> ZonedDateTime.now().until((Temporal)date, ChronoUnit.DAYS)).orElse(null);
    }

    @AcceptRequests
    public void start() throws Exception {
        this.server.start();
        if (!this.registerErrorHandler) {
            this.server.setErrorHandler(null);
        }
        Preconditions.checkState((boolean)this.server.isStarted(), (Object)"server is not started");
    }

    @PreDestroy
    public void stop() throws Exception {
        this.server.stop();
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }

    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Nested
    public MaxGauge getBusyThreads() {
        return this.busyThreads;
    }

    private static Set<X509Certificate> loadAllX509Certificates(HttpServerConfig config) {
        ImmutableSet.Builder certificates = ImmutableSet.builder();
        if (config.isHttpsEnabled()) {
            try (FileInputStream keystoreInputStream = new FileInputStream(config.getKeystorePath());){
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(keystoreInputStream, config.getKeystorePassword().toCharArray());
                for (String alias : Collections.list(keystore.aliases())) {
                    try {
                        Certificate certificate = keystore.getCertificate(alias);
                        if (!(certificate instanceof X509Certificate)) continue;
                        certificates.add((Object)((X509Certificate)certificate));
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return certificates.build();
    }

    private static ServerConnector createServerConnector(ServerSocketChannel channel, Server server, Executor executor, int acceptors, int selectors, ConnectionFactory ... factories) throws IOException {
        ServerConnector connector = new ServerConnector(server, executor, null, null, acceptors, selectors, factories);
        connector.open(channel);
        return connector;
    }

    static {
        String[] stringArray;
        if (System.getProperty("java.version").matches("11(\\.0\\.[12])?")) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "TLSv1.1";
            stringArray = stringArray2;
            stringArray2[1] = "TLSv1.2";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "TLSv1.1";
            stringArray3[1] = "TLSv1.2";
            stringArray = stringArray3;
            stringArray3[2] = "TLSv1.3";
        }
        ENABLED_PROTOCOLS = stringArray;
        ENABLED_CIPHERS = new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};
    }
}

