/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.http.server.TheServlet;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HttpServerBinder {
    private final Binder binder;

    private HttpServerBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
    }

    public static HttpServerBinder httpServerBinder(Binder binder) {
        return new HttpServerBinder(binder);
    }

    public HttpResourceBinding bindResource(String baseUri, String classPathResourceBase) {
        return this.bindResource(baseUri, classPathResourceBase, TheServlet.class);
    }

    private HttpResourceBinding bindResource(String baseUri, String classPathResourceBase, Class<? extends Annotation> annotationType) {
        HttpResourceBinding httpResourceBinding = new HttpResourceBinding(baseUri, classPathResourceBase);
        Multibinder.newSetBinder((Binder)this.binder, HttpResourceBinding.class, annotationType).addBinding().toInstance((Object)httpResourceBinding);
        return httpResourceBinding;
    }

    public static class HttpResourceBinding {
        private final String baseUri;
        private final String classPathResourceBase;
        private final List<String> welcomeFiles = new ArrayList<String>();

        public HttpResourceBinding(String baseUri, String classPathResourceBase) {
            this.baseUri = baseUri;
            this.classPathResourceBase = classPathResourceBase;
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public String getClassPathResourceBase() {
            return this.classPathResourceBase;
        }

        public List<String> getWelcomeFiles() {
            return ImmutableList.copyOf(this.welcomeFiles);
        }

        public HttpResourceBinding withWelcomeFile(String welcomeFile) {
            this.welcomeFiles.add(welcomeFile);
            return this;
        }
    }
}

