/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.proofpoint.http.server.ClientAddressExtractor;
import com.proofpoint.http.server.DoubleSummaryStats;
import com.proofpoint.http.server.HttpRequestEvent;
import com.proofpoint.http.server.RequestLog;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;

final class HttpServerChannelListener
implements HttpChannel.Listener {
    private static final String REQUEST_BEGIN_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".begin";
    private static final String REQUEST_BEGIN_TO_DISPATCH_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".begin_to_dispatch";
    private static final String REQUEST_BEGIN_TO_END_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".begin_to_end";
    private static final String RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".response_content_timestamps";
    private static final String REQUEST_SSL_SESSION_ATTRIBUTE = "org.eclipse.jetty.servlet.request.ssl_session";
    private final RequestLog logger;
    private final ClientAddressExtractor clientAddressExtractor;

    HttpServerChannelListener(RequestLog logger, ClientAddressExtractor clientAddressExtractor) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
        this.clientAddressExtractor = Objects.requireNonNull(clientAddressExtractor, "clientAddressExtractor is null");
    }

    public void onRequestBegin(Request request) {
        request.setAttribute(REQUEST_BEGIN_ATTRIBUTE, (Object)System.nanoTime());
    }

    public void onBeforeDispatch(Request request) {
        long requestBeginTime = (Long)request.getAttribute(REQUEST_BEGIN_ATTRIBUTE);
        request.setAttribute(REQUEST_BEGIN_TO_DISPATCH_ATTRIBUTE, (Object)(System.nanoTime() - requestBeginTime));
    }

    public void onRequestEnd(Request request) {
        long requestBeginTime = (Long)request.getAttribute(REQUEST_BEGIN_ATTRIBUTE);
        request.setAttribute(REQUEST_BEGIN_TO_END_ATTRIBUTE, (Object)(System.nanoTime() - requestBeginTime));
    }

    public void onResponseBegin(Request request) {
        if (request.getAttribute(REQUEST_BEGIN_TO_END_ATTRIBUTE) == null) {
            this.onRequestEnd(request);
        }
        request.setAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE, new ArrayList());
    }

    public void onResponseContent(Request request, ByteBuffer content) {
        List contentTimestamps = (List)request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE);
        contentTimestamps.add(System.nanoTime());
    }

    public void onComplete(Request request) {
        List contentTimestamps = (List)request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE);
        long firstToLastContentTimeInMillis = -1L;
        if (contentTimestamps.size() > 0) {
            firstToLastContentTimeInMillis = TimeUnit.NANOSECONDS.toMillis((Long)contentTimestamps.get(contentTimestamps.size() - 1) - (Long)contentTimestamps.get(0));
        }
        long beginToDispatchMillis = TimeUnit.NANOSECONDS.toMillis((Long)request.getAttribute(REQUEST_BEGIN_TO_DISPATCH_ATTRIBUTE));
        long beginToEndMillis = TimeUnit.NANOSECONDS.toMillis((Long)request.getAttribute(REQUEST_BEGIN_TO_END_ATTRIBUTE));
        SSLSession sslSession = (SSLSession)request.getAttribute(REQUEST_SSL_SESSION_ATTRIBUTE);
        HttpRequestEvent event = HttpRequestEvent.createHttpRequestEvent(request, request.getResponse(), sslSession, System.currentTimeMillis(), beginToDispatchMillis, beginToEndMillis, firstToLastContentTimeInMillis, HttpServerChannelListener.processContentTimestamps(contentTimestamps), this.clientAddressExtractor);
        this.logger.log(event);
    }

    @Nullable
    private static DoubleSummaryStats processContentTimestamps(List<Long> contentTimestamps) {
        Objects.requireNonNull(contentTimestamps, "contentTimestamps is null");
        if (contentTimestamps.size() == 0 || contentTimestamps.size() == 1) {
            return null;
        }
        DoubleSummaryStatistics statistics = new DoubleSummaryStatistics();
        long previousTimestamp = contentTimestamps.get(0);
        for (int i = 1; i < contentTimestamps.size(); ++i) {
            long timestamp = contentTimestamps.get(i);
            statistics.accept(TimeUnit.NANOSECONDS.toMillis(timestamp - previousTimestamp));
            previousTimestamp = timestamp;
        }
        return new DoubleSummaryStats(statistics);
    }
}

