/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.ConfigDescription;
import com.proofpoint.configuration.ConfigSecuritySensitive;
import com.proofpoint.configuration.DefunctConfig;
import com.proofpoint.units.DataSize;
import com.proofpoint.units.Duration;
import com.proofpoint.units.MaxDataSize;
import com.proofpoint.units.MinDataSize;
import com.proofpoint.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"jetty.http.enabled", "jetty.http.port", "jetty.https.enabled", "jetty.https.port", "jetty.https.keystore.path", "jetty.https.keystore.password", "http-server.https.keystore.password", "jetty.log.path", "jetty.threads.max", "jetty.threads.min", "jetty.threads.max-idle-time-ms", "jetty.log.retain-days", "jetty.auth.users-file", "jetty.net.max-idle-time-ms", "http-server.log.retention-time"})
public class HttpServerConfig {
    private boolean httpEnabled = true;
    private int httpPort = 8080;
    private int httpAcceptQueueSize = 128;
    private boolean httpsEnabled = false;
    private int httpsPort = 8443;
    private String keystorePath = "etc/keystore.jks";
    private String keystorePassword = "keystore";
    private Duration sslSessionTimeout = new Duration(4.0, TimeUnit.HOURS);
    private int sslSessionCacheSize = 10000;
    private String logPath = "var/log/http-request.log";
    private boolean logEnabled = true;
    private LogFormat logFormat = LogFormat.JSON;
    private DataSize logMaxSegmentSize = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private int logMaxHistory = 30;
    private DataSize logMaxTotalSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private int logQueueSize = 10000;
    private Integer httpAcceptorThreads;
    private Integer httpSelectorThreads;
    private Integer httpsAcceptorThreads;
    private Integer httpsSelectorThreads;
    private int minThreads = 2;
    private int maxThreads = 200;
    private Duration threadMaxIdleTime = new Duration(1.0, TimeUnit.MINUTES);
    private Duration networkMaxIdleTime = new Duration(200.0, TimeUnit.SECONDS);
    private Duration stopTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private DataSize maxRequestHeaderSize;
    private int http2MaxConcurrentStreams = 16384;
    private DataSize http2InitialSessionReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InitialStreamReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InputBufferSize = new DataSize(8.0, DataSize.Unit.KILOBYTE);
    private Duration http2StreamIdleTimeout = new Duration(15.0, TimeUnit.SECONDS);
    private String userAuthFile;
    private boolean adminEnabled = true;
    private int adminPort = 0;
    private int adminMinThreads = 2;
    private int adminMaxThreads = 200;
    private boolean showStackTrace = false;

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    @Config(value="http-server.http.enabled")
    public HttpServerConfig setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
        return this;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @Config(value="http-server.accept-queue-size")
    public HttpServerConfig setHttpAcceptQueueSize(int httpAcceptQueueSize) {
        this.httpAcceptQueueSize = httpAcceptQueueSize;
        return this;
    }

    public int getHttpAcceptQueueSize() {
        return this.httpAcceptQueueSize;
    }

    @Config(value="http-server.http.port")
    public HttpServerConfig setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    @Config(value="http-server.https.enabled")
    public HttpServerConfig setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
        return this;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    @Config(value="http-server.https.port")
    public HttpServerConfig setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getSslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    @Config(value="http-server.https.ssl-session-timeout")
    public HttpServerConfig setSslSessionTimeout(Duration sslSessionTimeout) {
        this.sslSessionTimeout = sslSessionTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    @Config(value="http-server.https.ssl-session-cache-size")
    public HttpServerConfig setSslSessionCacheSize(int sslSessionCacheSize) {
        this.sslSessionCacheSize = sslSessionCacheSize;
        return this;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Config(value="http-server.https.keystore.path")
    public HttpServerConfig setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Config(value="http-server.https.keystore.key")
    @ConfigSecuritySensitive
    public HttpServerConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="http-server.log.path")
    public HttpServerConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Config(value="http-server.log.enabled")
    public HttpServerConfig setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public LogFormat getLogFormat() {
        return this.logFormat;
    }

    @Config(value="http-server.log.format")
    public HttpServerConfig setLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpAcceptorThreads() {
        return this.httpAcceptorThreads;
    }

    @Config(value="http-server.http.acceptor-threads")
    public HttpServerConfig setHttpAcceptorThreads(Integer httpAcceptorThreads) {
        this.httpAcceptorThreads = httpAcceptorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpSelectorThreads() {
        return this.httpSelectorThreads;
    }

    @Config(value="http-server.http.selector-threads")
    public HttpServerConfig setHttpSelectorThreads(Integer httpSelectorThreads) {
        this.httpSelectorThreads = httpSelectorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpsAcceptorThreads() {
        return this.httpsAcceptorThreads;
    }

    @Config(value="http-server.https.acceptor-threads")
    public HttpServerConfig setHttpsAcceptorThreads(Integer httpsAcceptorThreads) {
        this.httpsAcceptorThreads = httpsAcceptorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpsSelectorThreads() {
        return this.httpsSelectorThreads;
    }

    @Config(value="http-server.https.selector-threads")
    public HttpServerConfig setHttpsSelectorThreads(Integer httpsSelectorThreads) {
        this.httpsSelectorThreads = httpsSelectorThreads;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-server.threads.max")
    public HttpServerConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-server.threads.min")
    public HttpServerConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    public Duration getThreadMaxIdleTime() {
        return this.threadMaxIdleTime;
    }

    @Config(value="http-server.threads.max-idle-time")
    public HttpServerConfig setThreadMaxIdleTime(Duration threadMaxIdleTime) {
        this.threadMaxIdleTime = threadMaxIdleTime;
        return this;
    }

    public DataSize getLogMaxSegmentSize() {
        return this.logMaxSegmentSize;
    }

    @Config(value="http-server.log.max-size")
    @ConfigDescription(value="Maximum size of a single request log file")
    public HttpServerConfig setLogMaxSegmentSize(DataSize logMaxSegmentSize) {
        this.logMaxSegmentSize = logMaxSegmentSize;
        return this;
    }

    public int getLogMaxHistory() {
        return this.logMaxHistory;
    }

    @Config(value="http-server.log.max-history")
    public HttpServerConfig setLogMaxHistory(int logMaxHistory) {
        this.logMaxHistory = logMaxHistory;
        return this;
    }

    public DataSize getLogMaxTotalSize() {
        return this.logMaxTotalSize;
    }

    @Config(value="http-server.log.max-total-size")
    @ConfigDescription(value="Maximum size of all archived request log files")
    public HttpServerConfig setLogMaxTotalSize(DataSize logMaxTotalSize) {
        this.logMaxTotalSize = logMaxTotalSize;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLogQueueSize() {
        return this.logQueueSize;
    }

    @Config(value="http-server.log.queue-size")
    public HttpServerConfig setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
        return this;
    }

    public String getUserAuthFile() {
        return this.userAuthFile;
    }

    @Config(value="http-server.auth.users-file")
    public HttpServerConfig setUserAuthFile(String userAuthFile) {
        this.userAuthFile = userAuthFile;
        return this;
    }

    public Duration getNetworkMaxIdleTime() {
        return this.networkMaxIdleTime;
    }

    @Config(value="http-server.net.max-idle-time")
    public HttpServerConfig setNetworkMaxIdleTime(Duration networkMaxIdleTime) {
        this.networkMaxIdleTime = networkMaxIdleTime;
        return this;
    }

    public boolean isAdminEnabled() {
        return this.adminEnabled;
    }

    @Config(value="http-server.admin.enabled")
    public HttpServerConfig setAdminEnabled(boolean adminEnabled) {
        this.adminEnabled = adminEnabled;
        return this;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    @Config(value="http-server.admin.port")
    public HttpServerConfig setAdminPort(int adminPort) {
        this.adminPort = adminPort;
        return this;
    }

    public int getAdminMinThreads() {
        return this.adminMinThreads;
    }

    @Config(value="http-server.admin.threads.min")
    public HttpServerConfig setAdminMinThreads(int adminMinThreads) {
        this.adminMinThreads = adminMinThreads;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getAdminMaxThreads() {
        return this.adminMaxThreads;
    }

    @Config(value="http-server.admin.threads.max")
    public HttpServerConfig setAdminMaxThreads(int adminMaxThreads) {
        this.adminMaxThreads = adminMaxThreads;
        return this;
    }

    public Duration getStopTimeout() {
        return this.stopTimeout;
    }

    @Config(value="http-server.stop-timeout")
    @ConfigDescription(value="On shutdown, amount of time to allow pending requests to complete before interrupting")
    public HttpServerConfig setStopTimeout(Duration stopTimeout) {
        this.stopTimeout = stopTimeout;
        return this;
    }

    public DataSize getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @Config(value="http-server.max-request-header-size")
    public HttpServerConfig setMaxRequestHeaderSize(DataSize maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttp2MaxConcurrentStreams() {
        return this.http2MaxConcurrentStreams;
    }

    @Config(value="http-server.http2.max-concurrent-streams")
    @ConfigDescription(value="Maximum concurrent streams per connection for HTTP/2")
    public HttpServerConfig setHttp2MaxConcurrentStreams(int http2MaxConcurrentStreams) {
        this.http2MaxConcurrentStreams = http2MaxConcurrentStreams;
        return this;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    @Config(value="http-server.show-stack-trace")
    @ConfigDescription(value="Show the stack trace when generating an error response")
    public HttpServerConfig setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialSessionReceiveWindowSize() {
        return this.http2InitialSessionReceiveWindowSize;
    }

    @Config(value="http-server.http2.session-receive-window-size")
    @ConfigDescription(value="Initial size of session's flow control receive window for HTTP/2")
    public HttpServerConfig setHttp2InitialSessionReceiveWindowSize(DataSize http2InitialSessionReceiveWindowSize) {
        this.http2InitialSessionReceiveWindowSize = http2InitialSessionReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialStreamReceiveWindowSize() {
        return this.http2InitialStreamReceiveWindowSize;
    }

    @Config(value="http-server.http2.stream-receive-window-size")
    @ConfigDescription(value="Initial size of stream's flow control receive window for HTTP/2")
    public HttpServerConfig setHttp2InitialStreamReceiveWindowSize(DataSize http2InitialStreamReceiveWindowSize) {
        this.http2InitialStreamReceiveWindowSize = http2InitialStreamReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="32MB")
    public DataSize getHttp2InputBufferSize() {
        return this.http2InputBufferSize;
    }

    @Config(value="http-server.http2.input-buffer-size")
    @ConfigDescription(value="Size of the buffer used to read from the network for HTTP/2")
    public HttpServerConfig setHttp2InputBufferSize(DataSize http2InputBufferSize) {
        this.http2InputBufferSize = http2InputBufferSize;
        return this;
    }

    public Duration getHttp2StreamIdleTimeout() {
        return this.http2StreamIdleTimeout;
    }

    @Config(value="http-server.http2.stream-idle-timeout")
    public HttpServerConfig setHttp2StreamIdleTimeout(Duration http2StreamIdleTimeout) {
        this.http2StreamIdleTimeout = http2StreamIdleTimeout;
        return this;
    }

    public static enum LogFormat {
        TSV,
        JSON;

    }
}

