/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class HttpServerInfo {
    private final URI httpUri;
    private final URI httpExternalUri;
    private final URI httpsUri;
    private final URI adminUri;
    private final URI adminExternalUri;
    private final ServerSocketChannel httpChannel;
    private final ServerSocketChannel httpsChannel;
    private final ServerSocketChannel adminChannel;

    @Inject
    public HttpServerInfo(HttpServerConfig config, NodeInfo nodeInfo) {
        if (config.isHttpEnabled()) {
            this.httpChannel = HttpServerInfo.createChannel(nodeInfo.getBindIp(), config.getHttpPort(), config.getHttpAcceptQueueSize());
            this.httpUri = HttpServerInfo.buildUri("http", InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp()), HttpServerInfo.port(this.httpChannel));
            this.httpExternalUri = HttpServerInfo.buildUri("http", nodeInfo.getExternalAddress(), this.httpUri.getPort());
        } else {
            this.httpChannel = null;
            this.httpUri = null;
            this.httpExternalUri = null;
        }
        if (config.isHttpsEnabled()) {
            this.httpsChannel = HttpServerInfo.createChannel(nodeInfo.getBindIp(), config.getHttpsPort(), config.getHttpAcceptQueueSize());
            this.httpsUri = HttpServerInfo.buildUri("https", nodeInfo.getInternalHostname(), HttpServerInfo.port(this.httpsChannel));
        } else {
            this.httpsChannel = null;
            this.httpsUri = null;
        }
        if (config.isAdminEnabled()) {
            this.adminChannel = HttpServerInfo.createChannel(nodeInfo.getBindIp(), config.getAdminPort(), config.getHttpAcceptQueueSize());
            if (config.isHttpsEnabled()) {
                this.adminUri = HttpServerInfo.buildUri("https", nodeInfo.getInternalHostname(), HttpServerInfo.port(this.adminChannel));
                this.adminExternalUri = null;
            } else {
                this.adminUri = HttpServerInfo.buildUri("http", InetAddresses.toUriString((InetAddress)nodeInfo.getInternalIp()), HttpServerInfo.port(this.adminChannel));
                this.adminExternalUri = HttpServerInfo.buildUri("http", nodeInfo.getExternalAddress(), this.adminUri.getPort());
            }
            Logger.get((String)"Bootstrap").info("Admin service on %s", new Object[]{this.adminUri});
        } else {
            this.adminChannel = null;
            this.adminUri = null;
            this.adminExternalUri = null;
        }
    }

    @Nullable
    public URI getHttpUri() {
        return this.httpUri;
    }

    @Nullable
    public URI getHttpExternalUri() {
        return this.httpExternalUri;
    }

    @Nullable
    public URI getHttpsUri() {
        return this.httpsUri;
    }

    @Nullable
    public URI getAdminUri() {
        return this.adminUri;
    }

    @Nullable
    public URI getAdminExternalUri() {
        return this.adminExternalUri;
    }

    @Nullable
    ServerSocketChannel getHttpChannel() {
        return this.httpChannel;
    }

    @Nullable
    ServerSocketChannel getHttpsChannel() {
        return this.httpsChannel;
    }

    @Nullable
    ServerSocketChannel getAdminChannel() {
        return this.adminChannel;
    }

    private static URI buildUri(String scheme, String host, int port) {
        try {
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    static int port(ServerSocketChannel channel) {
        try {
            return ((InetSocketAddress)channel.getLocalAddress()).getPort();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ServerSocketChannel createChannel(InetAddress address, int port, int acceptQueueSize) {
        try {
            ServerSocketChannel channel = ServerSocketChannel.open();
            channel.socket().setReuseAddress(true);
            channel.socket().bind(new InetSocketAddress(address, port), acceptQueueSize);
            return channel;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

