/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.proofpoint.bootstrap.LifeCycleManager;
import com.proofpoint.http.server.ClientAddressExtractor;
import com.proofpoint.http.server.DelimitedRequestLog;
import com.proofpoint.http.server.DetailedRequestStats;
import com.proofpoint.http.server.HttpServer;
import com.proofpoint.http.server.HttpServerBinder;
import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.http.server.HttpServerInfo;
import com.proofpoint.http.server.JsonRequestLog;
import com.proofpoint.http.server.QueryStringFilter;
import com.proofpoint.http.server.RequestLog;
import com.proofpoint.http.server.RequestStats;
import com.proofpoint.http.server.TheAdminServlet;
import com.proofpoint.http.server.TheServlet;
import com.proofpoint.node.NodeInfo;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.LoginService;

public class HttpServerProvider
implements Provider<HttpServer> {
    private final HttpServerInfo httpServerInfo;
    private final NodeInfo nodeInfo;
    private final HttpServerConfig config;
    private final Servlet theServlet;
    private final Set<HttpServerBinder.HttpResourceBinding> resources;
    private Map<String, String> servletInitParameters = ImmutableMap.of();
    private final Servlet theAdminServlet;
    private Map<String, String> adminServletInitParameters = ImmutableMap.of();
    private MBeanServer mbeanServer;
    private LoginService loginService;
    private final RequestStats stats;
    private final DetailedRequestStats detailedRequestStats;
    private final Set<Filter> filters;
    private final Set<Filter> adminFilters;
    private final QueryStringFilter queryStringFilter;
    private final ClientAddressExtractor clientAddressExtractor;
    private final LifeCycleManager lifeCycleManager;

    @Deprecated
    public HttpServerProvider(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet theServlet, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, Servlet theAdminServlet, Set<Filter> adminFilters, RequestStats stats, DetailedRequestStats detailedRequestStats, QueryStringFilter queryStringFilter, LifeCycleManager lifeCycleManager) {
        this(httpServerInfo, nodeInfo, config, theServlet, filters, resources, theAdminServlet, adminFilters, stats, detailedRequestStats, queryStringFilter, new ClientAddressExtractor(), lifeCycleManager);
    }

    @Inject
    public HttpServerProvider(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, @TheServlet Servlet theServlet, @TheServlet Set<Filter> filters, @TheServlet Set<HttpServerBinder.HttpResourceBinding> resources, @TheAdminServlet Servlet theAdminServlet, @TheAdminServlet Set<Filter> adminFilters, RequestStats stats, DetailedRequestStats detailedRequestStats, QueryStringFilter queryStringFilter, ClientAddressExtractor clientAddressExtractor, LifeCycleManager lifeCycleManager) {
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(theServlet, "theServlet is null");
        Objects.requireNonNull(filters, "filters is null");
        Objects.requireNonNull(resources, "resources is null");
        Objects.requireNonNull(theAdminServlet, "theAdminServlet is null");
        Objects.requireNonNull(adminFilters, "adminFilters is null");
        Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(detailedRequestStats, "detailedRequestStats is null");
        Objects.requireNonNull(clientAddressExtractor, "clientAddressExtractor is null");
        Objects.requireNonNull(queryStringFilter, "queryStringFilter is null");
        this.httpServerInfo = httpServerInfo;
        this.nodeInfo = nodeInfo;
        this.config = config;
        this.theServlet = theServlet;
        this.filters = ImmutableSet.copyOf(filters);
        this.resources = ImmutableSet.copyOf(resources);
        this.theAdminServlet = theAdminServlet;
        this.adminFilters = ImmutableSet.copyOf(adminFilters);
        this.stats = stats;
        this.detailedRequestStats = detailedRequestStats;
        this.queryStringFilter = queryStringFilter;
        this.clientAddressExtractor = clientAddressExtractor;
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
    }

    @Inject(optional=true)
    public void setServletInitParameters(@TheServlet Map<String, String> parameters) {
        this.servletInitParameters = ImmutableMap.copyOf(parameters);
    }

    @Inject(optional=true)
    public void setAdminServletInitParameters(@TheAdminServlet Map<String, String> parameters) {
        this.adminServletInitParameters = ImmutableMap.copyOf(parameters);
    }

    @Inject(optional=true)
    public void setMBeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    @Inject(optional=true)
    public void setLoginService(@Nullable LoginService loginService) {
        this.loginService = loginService;
    }

    public HttpServer get() {
        try {
            RequestLog requestLog = null;
            if (this.config.isLogEnabled()) {
                requestLog = this.createRequestLog(this.config);
            }
            HttpServer httpServer = new HttpServer(this.httpServerInfo, this.nodeInfo, this.config, this.theServlet, this.servletInitParameters, this.filters, this.resources, this.theAdminServlet, this.adminServletInitParameters, this.adminFilters, this.mbeanServer, this.loginService, this.queryStringFilter, this.stats, this.detailedRequestStats, requestLog, this.clientAddressExtractor);
            this.lifeCycleManager.addInstance((Object)httpServer);
            return httpServer;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected RequestLog createRequestLog(HttpServerConfig config) throws IOException {
        File logFile = new File(config.getLogPath());
        if (logFile.exists() && !logFile.isFile()) {
            throw new IOException(String.format("Log path %s exists but is not a file", logFile.getAbsolutePath()));
        }
        File logPath = logFile.getParentFile();
        if (!logPath.mkdirs() && !logPath.exists()) {
            throw new IOException(String.format("Cannot create %s and path does not already exist", logPath.getAbsolutePath()));
        }
        if (config.getLogFormat() == HttpServerConfig.LogFormat.TSV) {
            return new DelimitedRequestLog(config);
        }
        return new JsonRequestLog(config);
    }
}

