/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;

final class Inet4Network {
    private final int bits;
    private final long start;
    private final long end;

    private Inet4Network(Inet4Address address, int bits) {
        this.bits = bits;
        this.start = Inet4Network.addressToLong(address);
        long length = 1L << 32 - this.bits;
        this.end = this.start + length - 1L;
    }

    public boolean containsAddress(Inet4Address address) {
        long ip = Inet4Network.addressToLong(address);
        return ip >= this.start && ip <= this.end;
    }

    public String toString() {
        return InetAddresses.fromInteger((int)((int)this.start)).getHostAddress() + "/" + this.bits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inet4Network that = (Inet4Network)o;
        if (this.bits != that.bits) {
            return false;
        }
        return this.start == that.start;
    }

    public int hashCode() {
        int result = (int)this.start;
        result = 31 * result + this.bits;
        return result;
    }

    public static Inet4Network fromCidr(String cidr) {
        String[] parts = cidr.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid CIDR format: " + cidr);
        }
        Inet4Address address = (Inet4Address)InetAddresses.forString((String)parts[0]);
        int bits = Integer.parseInt(parts[1]);
        if (bits < 0 || bits > 32) {
            throw new IllegalArgumentException("invalid prefix size: " + bits);
        }
        int mask = bits == 0 ? 0 : -1 << 32 - bits;
        int ip = InetAddresses.coerceToInteger((InetAddress)address);
        if ((ip & mask) != ip) {
            throw new IllegalArgumentException("invalid prefix for prefix size: " + bits);
        }
        return new Inet4Network(address, bits);
    }

    static long addressToLong(Inet4Address address) {
        return (long)InetAddresses.coerceToInteger((InetAddress)address) & 0xFFFFFFFFL;
    }
}

