/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import com.proofpoint.http.server.HttpRequestEvent;
import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.http.server.RequestLog;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.log.Logging;
import com.proofpoint.units.DataSize;
import com.proofpoint.units.Duration;
import java.util.concurrent.TimeUnit;

class JsonRequestLog
implements RequestLog {
    private final Appender<HttpRequestEvent> appender;

    JsonRequestLog(HttpServerConfig config) {
        this.appender = Logging.createFileAppender((String)config.getLogPath(), (int)config.getLogMaxHistory(), (int)config.getLogQueueSize(), (Duration)new Duration(10.0, TimeUnit.SECONDS), (DataSize)config.getLogMaxSegmentSize(), (DataSize)config.getLogMaxTotalSize(), (Encoder)new EventEncoder(), (Context)new ContextBase());
    }

    @Override
    public void log(HttpRequestEvent event) {
        this.appender.doAppend((Object)event);
    }

    @Override
    public void stop() {
        this.appender.stop();
    }

    private static class EventEncoder
    extends EncoderBase<HttpRequestEvent> {
        private final JsonCodec<HttpRequestEvent> codec = JsonCodec.jsonCodec(HttpRequestEvent.class).withoutPretty();

        private EventEncoder() {
        }

        public byte[] headerBytes() {
            return null;
        }

        public byte[] encode(HttpRequestEvent event) {
            byte[] jsonBytes = this.codec.toJsonBytes((Object)event);
            byte[] line = new byte[jsonBytes.length + 1];
            System.arraycopy(jsonBytes, 0, line, 0, jsonBytes.length);
            line[jsonBytes.length] = 10;
            return line;
        }

        public byte[] footerBytes() {
            return null;
        }
    }
}

