/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.proofpoint.stats.DistributionStat;
import com.proofpoint.stats.TimeStat;
import com.proofpoint.units.Duration;
import javax.inject.Inject;
import org.weakref.jmx.Nested;

public class RequestStats {
    private final TimeStat requestTime = new TimeStat();
    private final DistributionStat readBytes = new DistributionStat();
    private final DistributionStat writtenBytes = new DistributionStat();

    @Inject
    public RequestStats() {
    }

    @Deprecated
    public void record(String method, int responseCode, long requestSizeInBytes, long responseSizeInBytes, Duration schedulingDelay, Duration requestProcessingTime) {
        this.record(requestSizeInBytes, responseSizeInBytes, requestProcessingTime);
    }

    public void record(long requestSizeInBytes, long responseSizeInBytes, Duration requestProcessingTime) {
        this.requestTime.add(requestProcessingTime);
        this.readBytes.add(requestSizeInBytes);
        this.writtenBytes.add(responseSizeInBytes);
    }

    @Nested
    public TimeStat getRequestTime() {
        return this.requestTime;
    }

    @Nested
    public DistributionStat getReadBytes() {
        return this.readBytes;
    }

    @Nested
    public DistributionStat getWrittenBytes() {
        return this.writtenBytes;
    }
}

