/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.proofpoint.http.server.DetailedRequestStats;
import com.proofpoint.http.server.RequestStats;
import com.proofpoint.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;

public class StatsRecordingHandler
implements RequestLog {
    private static final String REQUEST_SSL_SESSION_ATTRIBUTE = "org.eclipse.jetty.servlet.request.ssl_session";
    private final RequestStats stats;
    private final DetailedRequestStats detailedRequestStats;

    public StatsRecordingHandler(RequestStats stats, DetailedRequestStats detailedRequestStats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.detailedRequestStats = Objects.requireNonNull(detailedRequestStats, "detailedRequestStats is null");
    }

    public void log(Request request, Response response) {
        Duration requestTime = new Duration((double)Math.max(0L, System.currentTimeMillis() - request.getTimeStamp()), TimeUnit.MILLISECONDS);
        SSLSession sslSession = (SSLSession)request.getAttribute(REQUEST_SSL_SESSION_ATTRIBUTE);
        this.stats.record(request.getContentRead(), response.getContentCount(), requestTime);
        this.detailedRequestStats.requestTimeByCode(response.getStatus(), response.getStatus() / 100).add(requestTime);
        if (sslSession != null) {
            this.detailedRequestStats.tlsRequest(sslSession.getProtocol(), sslSession.getCipherSuite()).add(1L);
        }
    }
}

