/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.server;

import com.proofpoint.http.server.ClientAddressExtractor;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class TraceTokenFilter
implements Filter {
    private static final JsonCodec<TraceToken> TRACE_TOKEN_JSON_CODEC = JsonCodec.jsonCodec(TraceToken.class);
    private static final Base64.Encoder BASE64_URL_ENCODER = Base64.getUrlEncoder();
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = ThreadLocal.withInitial(SecureRandom::new);
    private final ClientAddressExtractor clientAddressExtractor;
    private final String tokenPrefix;

    TraceTokenFilter(InetAddress internalIp, ClientAddressExtractor clientAddressExtractor) {
        this.tokenPrefix = TraceTokenFilter.encodeAddress(Objects.requireNonNull(internalIp, "internalIp is null"));
        this.clientAddressExtractor = Objects.requireNonNull(clientAddressExtractor, "clientAddressExtractor is null");
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String token = request.getHeader("X-Proofpoint-TraceToken");
        if (token == null || token.isEmpty()) {
            this.registerNewRequestToken(request);
        } else if (token.charAt(0) == '{') {
            try {
                TraceTokenManager.registerTraceToken((TraceToken)((TraceToken)TRACE_TOKEN_JSON_CODEC.fromJson(token)));
            }
            catch (RuntimeException e) {
                this.registerNewRequestToken(request);
            }
        } else {
            TraceTokenManager.registerRequestToken((String)token);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    private static String encodeAddress(InetAddress inetAddress) {
        byte[] address = inetAddress.getAddress();
        if (address.length > 6) {
            address = Arrays.copyOfRange(address, address.length - 6, address.length);
        } else if (address.length == 4 && address[0] == 10) {
            address = Arrays.copyOfRange(address, 1, 4);
        }
        String encoded = BASE64_URL_ENCODER.encodeToString(address);
        if (encoded.endsWith("==")) {
            return encoded.replace("==", "=");
        }
        if (encoded.endsWith("=")) {
            return encoded;
        }
        return encoded + "=";
    }

    private void registerNewRequestToken(HttpServletRequest request) throws UnknownHostException {
        byte[] randomBytes = new byte[15];
        SECURE_RANDOM.get().nextBytes(randomBytes);
        TraceTokenManager.registerRequestToken((String)(this.tokenPrefix + TraceTokenFilter.encodeAddress(InetAddress.getByName(this.clientAddressExtractor.clientAddressFor(request))) + BASE64_URL_ENCODER.encodeToString(randomBytes)));
    }
}

