/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptorsListener;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.node.NodeInfo;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class CachingServiceSelector
implements ServiceSelector,
ServiceDescriptorsListener {
    private final String type;
    private final String pool;
    private final AtomicReference<List<ServiceDescriptor>> serviceDescriptors = new AtomicReference<ImmutableList>(ImmutableList.of());

    public CachingServiceSelector(String type, ServiceSelectorConfig selectorConfig, NodeInfo nodeInfo) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.type = type;
        this.pool = (String)MoreObjects.firstNonNull((Object)selectorConfig.getPool(), (Object)nodeInfo.getPool());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        return this.serviceDescriptors.get();
    }

    @Override
    public void updateServiceDescriptors(Iterable<ServiceDescriptor> newDescriptors) {
        this.serviceDescriptors.set((List<ServiceDescriptor>)ImmutableList.copyOf(Objects.requireNonNull(newDescriptors)));
    }
}

