/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.proofpoint.discovery.client.CachingServiceSelector;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.ServiceDescriptorsUpdater;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.ServiceSelectorFactory;
import com.proofpoint.node.NodeInfo;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public class CachingServiceSelectorFactory
implements ServiceSelectorFactory {
    private final DiscoveryLookupClient lookupClient;
    private final ScheduledExecutorService executor;
    private final NodeInfo nodeInfo;

    @Inject
    public CachingServiceSelectorFactory(DiscoveryLookupClient lookupClient, @ForDiscoveryClient ScheduledExecutorService executor, NodeInfo nodeInfo) {
        Objects.requireNonNull(lookupClient, "client is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.lookupClient = lookupClient;
        this.executor = executor;
        this.nodeInfo = nodeInfo;
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        CachingServiceSelector serviceSelector = new CachingServiceSelector(type, selectorConfig, this.nodeInfo);
        ServiceDescriptorsUpdater updater = new ServiceDescriptorsUpdater(serviceSelector, type, selectorConfig, this.nodeInfo, this.lookupClient, this.executor);
        updater.start();
        return serviceSelector;
    }
}

