/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.CaseFormat;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.discovery.client.HttpServiceSelector;
import com.proofpoint.discovery.client.HttpServiceSelectorProvider;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.ServiceSelectorProvider;
import com.proofpoint.discovery.client.ServiceType;
import com.proofpoint.discovery.client.ServiceTypes;
import com.proofpoint.discovery.client.announce.AnnouncementHttpServerInfo;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerProvider;
import com.proofpoint.http.client.HttpClientBinder;
import com.proofpoint.http.client.balancing.BalancingHttpClientBindingBuilder;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class DiscoveryBinder {
    private final Multibinder<ServiceAnnouncement> serviceAnnouncementBinder;
    private final Binder binder;

    public static DiscoveryBinder discoveryBinder(Binder binder) {
        Objects.requireNonNull(binder, "binder is null");
        return new DiscoveryBinder(binder);
    }

    protected DiscoveryBinder(Binder binder) {
        Objects.requireNonNull(binder, "binder is null");
        this.binder = binder.skipSources(new Class[]{this.getClass()});
        this.serviceAnnouncementBinder = Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
    }

    public void bindSelector(String type) {
        Objects.requireNonNull(type, "type is null");
        this.bindSelector(ServiceTypes.serviceType(type));
    }

    public void bindSelector(ServiceType serviceType) {
        Objects.requireNonNull(serviceType, "serviceType is null");
        ConfigBinder.bindConfig((Binder)this.binder).bind(ServiceSelectorConfig.class).annotatedWith((Annotation)serviceType).prefixedWith("discovery." + serviceType.value());
        this.binder.bind(ServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new ServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    public void bindHttpBalancer(String type) {
        Objects.requireNonNull(type, "type is null");
        this.bindHttpBalancer(ServiceTypes.serviceType(type));
    }

    public void bindHttpBalancer(ServiceType serviceType) {
        Objects.requireNonNull(serviceType, "serviceType is null");
        ConfigBinder.bindConfig((Binder)this.binder).bind(HttpServiceBalancerConfig.class).annotatedWith((Annotation)serviceType).prefixedWith("service-balancer." + serviceType.value());
        this.binder.bind(HttpServiceBalancer.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new HttpServiceBalancerProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    public void bindServiceAnnouncement(ServiceAnnouncement announcement) {
        Objects.requireNonNull(announcement, "announcement is null");
        this.serviceAnnouncementBinder.addBinding().toInstance((Object)announcement);
    }

    public void bindServiceAnnouncement(Provider<ServiceAnnouncement> announcementProvider) {
        Objects.requireNonNull(announcementProvider, "announcementProvider is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProvider).in(Scopes.SINGLETON);
    }

    public <T extends ServiceAnnouncement> void bindServiceAnnouncement(Class<? extends Provider<T>> announcementProviderClass) {
        Objects.requireNonNull(announcementProviderClass, "announcementProviderClass is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProviderClass).in(Scopes.SINGLETON);
    }

    public ServiceAnnouncement.ServiceAnnouncementBuilder bindHttpAnnouncement(String type) {
        ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder = ServiceAnnouncement.serviceAnnouncement(type);
        this.bindServiceAnnouncement(new HttpAnnouncementProvider(serviceAnnouncementBuilder));
        return serviceAnnouncementBuilder;
    }

    @Deprecated
    public void bindHttpSelector(String type) {
        Objects.requireNonNull(type, "type is null");
        this.bindHttpSelector(ServiceTypes.serviceType(type));
    }

    @Deprecated
    public void bindHttpSelector(ServiceType serviceType) {
        Objects.requireNonNull(serviceType, "serviceType is null");
        this.bindSelector(serviceType);
        this.binder.bind(HttpServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new HttpServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String type) {
        return this.bindDiscoveredHttpClient(Objects.requireNonNull(type, "type is null"), ServiceTypes.serviceType(type));
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String name, ServiceType serviceType) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(serviceType, "serviceType is null");
        this.bindHttpBalancer(serviceType);
        String serviceName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, serviceType.value());
        return HttpClientBinder.httpClientBinder((Binder)this.binder).bindBalancingHttpClient(name, (Annotation)serviceType, serviceName, Key.get(HttpServiceBalancer.class, (Annotation)serviceType));
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String type, Class<? extends Annotation> annotation) {
        return this.bindDiscoveredHttpClient(ServiceTypes.serviceType(Objects.requireNonNull(type, "type is null")), annotation);
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(ServiceType serviceType, Class<? extends Annotation> annotation) {
        return this.bindDiscoveredHttpClient(serviceType.value(), serviceType, annotation);
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String name, ServiceType serviceType, Class<? extends Annotation> annotation) {
        this.bindHttpBalancer(serviceType);
        return HttpClientBinder.httpClientBinder((Binder)this.binder).bindBalancingHttpClient(name, annotation, Key.get(HttpServiceBalancer.class, (Annotation)serviceType));
    }

    static class HttpAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private final ServiceAnnouncement.ServiceAnnouncementBuilder builder;
        private AnnouncementHttpServerInfo httpServerInfo;

        HttpAnnouncementProvider(ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder) {
            this.builder = serviceAnnouncementBuilder;
        }

        @Inject
        public void setAnnouncementHttpServerInfo(AnnouncementHttpServerInfo httpServerInfo) {
            this.httpServerInfo = httpServerInfo;
        }

        public ServiceAnnouncement get() {
            URI httpsUri;
            if (this.httpServerInfo.getHttpUri() != null) {
                this.builder.addProperty("http", this.httpServerInfo.getHttpUri().toString());
                this.builder.addProperty("http-external", this.httpServerInfo.getHttpExternalUri().toString());
            }
            if ((httpsUri = this.httpServerInfo.getHttpsUri()) != null) {
                if (!httpsUri.getHost().contains(".")) {
                    return ServiceAnnouncement.serviceAnnouncementError("HttpServer's HTTPS URI host \"" + httpsUri.getHost() + "\" must be a FQDN");
                }
                this.builder.addProperty("https", httpsUri.toString());
            }
            if (this.httpServerInfo.getAdminUri() != null) {
                this.builder.addProperty("admin", this.httpServerInfo.getAdminUri().toString());
            }
            return this.builder.build();
        }
    }
}

