/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.concurrent.Threads;
import com.proofpoint.configuration.AbstractConfigurationAwareModule;
import com.proofpoint.configuration.Config;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.configuration.ConfigurationDefaultingModule;
import com.proofpoint.discovery.client.CachingServiceSelectorFactory;
import com.proofpoint.discovery.client.DiscoveryAddressLookup;
import com.proofpoint.discovery.client.DiscoveryClientConfig;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.HttpDiscoveryLookupClient;
import com.proofpoint.discovery.client.ServiceDescriptorsRepresentation;
import com.proofpoint.discovery.client.ServiceInventory;
import com.proofpoint.discovery.client.ServiceInventoryConfig;
import com.proofpoint.discovery.client.ServiceSelectorFactory;
import com.proofpoint.discovery.client.ServiceType;
import com.proofpoint.discovery.client.ServiceTypes;
import com.proofpoint.discovery.client.StaticDiscoveryModule;
import com.proofpoint.discovery.client.announce.Announcement;
import com.proofpoint.discovery.client.announce.Announcer;
import com.proofpoint.discovery.client.announce.AnnouncerImpl;
import com.proofpoint.discovery.client.announce.DiscoveryAnnouncementClient;
import com.proofpoint.discovery.client.announce.HttpDiscoveryAnnouncementClient;
import com.proofpoint.discovery.client.announce.NullAnnouncer;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerFactory;
import com.proofpoint.http.client.HttpClientBinder;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.http.client.balancing.HttpServiceBalancerStats;
import com.proofpoint.json.JsonCodecBinder;
import com.proofpoint.reporting.ReportCollectionFactory;
import com.proofpoint.reporting.ReportExporter;
import com.proofpoint.units.Duration;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.PreDestroy;
import javax.inject.Provider;
import org.weakref.jmx.guice.ExportBinder;

public class DiscoveryModule
extends AbstractConfigurationAwareModule
implements ConfigurationDefaultingModule {
    public Map<String, String> getConfigurationDefaults() {
        return ImmutableMap.of((Object)"discovery.http-client.idle-timeout", (Object)"5s");
    }

    public void setup(Binder binder) {
        if (((DiscoveryClientConfig)this.buildConfigObject(DiscoveryClientConfig.class)).isDiscoveryStatic()) {
            binder.install((Module)new StaticDiscoveryModule());
            binder.bind(Announcer.class).to(NullAnnouncer.class).in(Scopes.SINGLETON);
            ConfigBinder.bindConfig((Binder)binder).bind(ConsumeIdleTimeout.class);
            return;
        }
        binder.install((Module)new NonstaticDiscoveryModule());
    }

    private static class ConsumeIdleTimeout {
        private ConsumeIdleTimeout() {
        }

        public Duration getIdleTimeout() {
            return null;
        }

        @Config(value="discovery.http-client.idle-timeout")
        public void setIdleTimeout(Duration timeout) {
        }
    }

    private static class NonstaticDiscoveryModule
    implements Module {
        private HttpServiceBalancerImpl discoveryBalancer = null;

        private NonstaticDiscoveryModule() {
        }

        public void configure(Binder binder) {
            binder.bind(ServiceInventory.class).asEagerSingleton();
            ConfigBinder.bindConfig((Binder)binder).bind(ServiceInventoryConfig.class);
            binder.bind(DiscoveryAddressLookup.class).in(Scopes.SINGLETON);
            ConfigBinder.bindConfig((Binder)binder).bind(HttpServiceBalancerConfig.class).annotatedWith(ForDiscoveryClient.class).prefixedWith("service-balancer.discovery");
            ConfigBinder.bindConfig((Binder)binder).bind(DiscoveryClientConfig.class);
            binder.bind(DiscoveryLookupClient.class).to(HttpDiscoveryLookupClient.class).in(Scopes.SINGLETON);
            binder.bind(DiscoveryAnnouncementClient.class).to(HttpDiscoveryAnnouncementClient.class).in(Scopes.SINGLETON);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ServiceDescriptorsRepresentation.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Announcement.class);
            HttpClientBinder.httpClientBinder((Binder)binder).bindBalancingHttpClient("discovery", ForDiscoveryClient.class, Key.get(HttpServiceBalancer.class, (Annotation)ServiceTypes.serviceType("discovery")));
            binder.bind(Announcer.class).to(AnnouncerImpl.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
            binder.bind(ServiceSelectorFactory.class).to(CachingServiceSelectorFactory.class).in(Scopes.SINGLETON);
            binder.bind(HttpServiceBalancerFactory.class).in(Scopes.SINGLETON);
            binder.bind(ScheduledExecutorService.class).annotatedWith(ForDiscoveryClient.class).toProvider(DiscoveryExecutorProvider.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(ServiceInventory.class).withGeneratedName();
        }

        @Provides
        @ServiceType(value="discovery")
        public HttpServiceBalancer createHttpServiceBalancer(ReportExporter reportExporter, ReportCollectionFactory reportCollectionFactory, @ForDiscoveryClient HttpServiceBalancerConfig config) {
            return this.getHttpServiceBalancerImpl(reportExporter, reportCollectionFactory, config);
        }

        @ServiceType(value="discovery")
        @Provides
        public synchronized HttpServiceBalancerImpl getHttpServiceBalancerImpl(ReportExporter reportExporter, ReportCollectionFactory reportCollectionFactory, @ForDiscoveryClient HttpServiceBalancerConfig config) {
            if (this.discoveryBalancer == null) {
                ImmutableMap tags = ImmutableMap.of((Object)"serviceType", (Object)"discovery");
                this.discoveryBalancer = new HttpServiceBalancerImpl("discovery", (HttpServiceBalancerStats)reportCollectionFactory.createReportCollection(HttpServiceBalancerStats.class, false, "ServiceClient", (Map)tags), config);
                reportExporter.export((Object)this.discoveryBalancer, false, "ServiceClient", (Map)tags);
            }
            return this.discoveryBalancer;
        }

        private static class DiscoveryExecutorProvider
        implements Provider<ScheduledExecutorService> {
            private ScheduledExecutorService executor;

            private DiscoveryExecutorProvider() {
            }

            public ScheduledExecutorService get() {
                Preconditions.checkState((this.executor == null ? 1 : 0) != 0, (Object)"provider already used");
                this.executor = new ScheduledThreadPoolExecutor(5, Threads.daemonThreadsNamed((String)"Discovery-%s"));
                return this.executor;
            }

            @PreDestroy
            public void destroy() {
                if (this.executor != null) {
                    this.executor.shutdownNow();
                }
            }
        }
    }
}

