/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.collect.ImmutableList;
import com.proofpoint.discovery.client.DiscoveryException;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.units.Duration;
import java.util.List;
import java.util.Objects;

public class ServiceDescriptors {
    private final String type;
    private final String pool;
    private final String eTag;
    private final Duration maxAge;
    private final List<ServiceDescriptor> serviceDescriptors;

    public ServiceDescriptors(ServiceDescriptors serviceDescriptors, Duration maxAge, String eTag) {
        Objects.requireNonNull(serviceDescriptors, "serviceDescriptors is null");
        this.type = serviceDescriptors.type;
        this.pool = serviceDescriptors.pool;
        this.maxAge = maxAge;
        this.eTag = eTag;
        this.serviceDescriptors = serviceDescriptors.serviceDescriptors;
    }

    public ServiceDescriptors(String type, String pool, List<ServiceDescriptor> serviceDescriptors, Duration maxAge, String eTag) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(serviceDescriptors, "serviceDescriptors is null");
        Objects.requireNonNull(maxAge, "maxAge is null");
        this.type = type;
        this.pool = pool;
        this.serviceDescriptors = ImmutableList.copyOf(serviceDescriptors);
        this.maxAge = maxAge;
        this.eTag = eTag;
        for (ServiceDescriptor serviceDescriptor : this.serviceDescriptors) {
            if (type.equals(serviceDescriptor.getType()) && (pool == null || pool.equals(serviceDescriptor.getPool()))) continue;
            throw new DiscoveryException(String.format("Expected %s service descriptor from pool %s, but was %s service descriptor from pool %s", type, pool, serviceDescriptor.getType(), serviceDescriptor.getPool()));
        }
    }

    public String getType() {
        return this.type;
    }

    public String getPool() {
        return this.pool;
    }

    public String getETag() {
        return this.eTag;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public List<ServiceDescriptor> getServiceDescriptors() {
        return this.serviceDescriptors;
    }
}

