/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ExponentialBackOff;
import com.proofpoint.discovery.client.ServiceDescriptors;
import com.proofpoint.discovery.client.ServiceDescriptorsListener;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.announce.DiscoveryAnnouncementClient;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.units.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;

public final class ServiceDescriptorsUpdater {
    private static final Logger log = Logger.get(ServiceDescriptorsUpdater.class);
    private final ServiceDescriptorsListener target;
    private final String type;
    private final String pool;
    private final DiscoveryLookupClient discoveryClient;
    private final AtomicReference<ServiceDescriptors> serviceDescriptors = new AtomicReference();
    private final ScheduledExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ExponentialBackOff errorBackOff;

    public ServiceDescriptorsUpdater(ServiceDescriptorsListener target, String type, ServiceSelectorConfig selectorConfig, NodeInfo nodeInfo, DiscoveryLookupClient discoveryClient, ScheduledExecutorService executor) {
        Objects.requireNonNull(target, "target is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(discoveryClient, "discoveryClient is null");
        Objects.requireNonNull(executor, "executor is null");
        this.target = target;
        this.type = type;
        this.pool = (String)MoreObjects.firstNonNull((Object)selectorConfig.getPool(), (Object)nodeInfo.getPool());
        this.discoveryClient = discoveryClient;
        this.executor = executor;
        this.errorBackOff = new ExponentialBackOff(new Duration(1.0, TimeUnit.MILLISECONDS), new Duration(1.0, TimeUnit.SECONDS), String.format("Discovery server connect succeeded for refresh (%s/%s)", type, this.pool), String.format("Cannot connect to discovery server for refresh (%s/%s)", type, this.pool), log);
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            Preconditions.checkState((!this.executor.isShutdown() ? 1 : 0) != 0, (Object)"CachingServiceSelector has been destroyed");
            try {
                this.refresh().get(1L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ListenableFuture<ServiceDescriptors> refresh() {
        ServiceDescriptors oldDescriptors = this.serviceDescriptors.get();
        ListenableFuture<ServiceDescriptors> future = oldDescriptors == null ? this.discoveryClient.getServices(this.type, this.pool) : this.discoveryClient.refreshServices(oldDescriptors);
        return ServiceDescriptorsUpdater.chainedCallback(future, new FutureCallback<ServiceDescriptors>(){

            public void onSuccess(ServiceDescriptors newDescriptors) {
                ServiceDescriptorsUpdater.this.serviceDescriptors.set(newDescriptors);
                ServiceDescriptorsUpdater.this.target.updateServiceDescriptors(newDescriptors.getServiceDescriptors());
                ServiceDescriptorsUpdater.this.errorBackOff.success();
                Duration delay = newDescriptors.getMaxAge();
                if (delay == null) {
                    delay = DiscoveryAnnouncementClient.DEFAULT_DELAY;
                }
                ServiceDescriptorsUpdater.this.scheduleRefresh(delay);
            }

            public void onFailure(Throwable t) {
                Duration duration = ServiceDescriptorsUpdater.this.errorBackOff.failed(t);
                ServiceDescriptorsUpdater.this.scheduleRefresh(duration);
            }
        }, this.executor);
    }

    private void scheduleRefresh(Duration delay) {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.schedule(this::refresh, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static <V> ListenableFuture<V> chainedCallback(ListenableFuture<V> future, final FutureCallback<? super V> callback, Executor executor) {
        final SettableFuture done = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V result) {
                try {
                    callback.onSuccess(result);
                }
                finally {
                    done.set(result);
                }
            }

            public void onFailure(Throwable t) {
                try {
                    callback.onFailure(t);
                }
                finally {
                    done.setException(t);
                }
            }
        }, (Executor)executor);
        return done;
    }
}

