/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.proofpoint.concurrent.Threads;
import com.proofpoint.discovery.client.DiscoveryAddressLookup;
import com.proofpoint.discovery.client.DiscoveryClientConfig;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptorsListener;
import com.proofpoint.discovery.client.ServiceDescriptorsRepresentation;
import com.proofpoint.discovery.client.ServiceInventoryConfig;
import com.proofpoint.discovery.client.ServiceState;
import com.proofpoint.discovery.client.ServiceType;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerListenerAdapter;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.units.Duration;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class ServiceInventory {
    private static final Logger log = Logger.get(ServiceInventory.class);
    private final String environment;
    private final URI serviceInventoryUri;
    private final URI discoveryServiceURI;
    private final Duration updateInterval;
    private final JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec;
    private final DiscoveryAddressLookup discoveryAddressLookup;
    private final ServiceDescriptorsListener discoveryListener;
    private final AtomicReference<List<ServiceDescriptor>> serviceDescriptors = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"service-inventory-%s"));
    private final AtomicBoolean serverUp = new AtomicBoolean(true);
    private ScheduledFuture<?> scheduledFuture = null;

    public ServiceInventory(ServiceInventoryConfig serviceInventoryConfig, DiscoveryClientConfig discoveryClientConfig, NodeInfo nodeInfo, JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec, @ServiceType(value="discovery") HttpServiceBalancerImpl discoveryBalancer) {
        this(serviceInventoryConfig, discoveryClientConfig, nodeInfo, serviceDescriptorsCodec, discoveryBalancer, new DiscoveryAddressLookup());
    }

    @Inject
    ServiceInventory(ServiceInventoryConfig serviceInventoryConfig, DiscoveryClientConfig discoveryClientConfig, NodeInfo nodeInfo, JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec, @ServiceType(value="discovery") HttpServiceBalancerImpl discoveryBalancer, DiscoveryAddressLookup discoveryAddressLookup) {
        Objects.requireNonNull(serviceInventoryConfig, "serviceInventoryConfig is null");
        Objects.requireNonNull(discoveryClientConfig, "discoveryClientConfig is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(serviceDescriptorsCodec, "serviceDescriptorsCodec is null");
        Objects.requireNonNull(discoveryBalancer, "discoveryBalancer is null");
        Objects.requireNonNull(discoveryAddressLookup, "discoveryAddressLookup is null");
        this.environment = nodeInfo.getEnvironment();
        this.serviceInventoryUri = serviceInventoryConfig.getServiceInventoryUri();
        if (this.serviceInventoryUri == null) {
            this.discoveryServiceURI = discoveryClientConfig.getDiscoveryServiceURI();
        } else {
            this.discoveryServiceURI = null;
            String scheme = this.serviceInventoryUri.getScheme().toLowerCase();
            Preconditions.checkArgument((boolean)scheme.equals("file"), (Object)"Service inventory uri must have a file scheme");
        }
        this.updateInterval = serviceInventoryConfig.getUpdateInterval();
        this.serviceDescriptorsCodec = serviceDescriptorsCodec;
        this.discoveryAddressLookup = discoveryAddressLookup;
        this.discoveryListener = new HttpServiceBalancerListenerAdapter(discoveryBalancer);
        if (this.discoveryServiceURI != null) {
            discoveryBalancer.updateHttpUris((Collection)ImmutableMultiset.of((Object)this.discoveryServiceURI));
        } else {
            try {
                this.updateServiceInventory();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @PostConstruct
    public synchronized void start() {
        if (this.discoveryServiceURI != null || this.scheduledFuture != null) {
            return;
        }
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(() -> {
            try {
                this.updateServiceInventory();
            }
            catch (Throwable e) {
                log.error(e, "Unexpected exception from service inventory update", new Object[0]);
            }
        }, this.updateInterval.toMillis(), this.updateInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors() {
        return this.serviceDescriptors.get();
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors(String type) {
        return this.serviceDescriptors.get().stream().filter(serviceDescriptor -> serviceDescriptor.getType().equals(type)).collect(Collectors.toList());
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors(String type, String pool) {
        return this.serviceDescriptors.get().stream().filter(serviceDescriptor -> serviceDescriptor.getType().equals(type)).filter(serviceDescriptor -> serviceDescriptor.getPool().equals(pool)).collect(Collectors.toList());
    }

    @Managed
    public final void updateServiceInventory() {
        List descriptors;
        if (this.discoveryServiceURI != null) {
            return;
        }
        if (this.serviceInventoryUri != null) {
            try {
                File file = new File(this.serviceInventoryUri);
                ServiceDescriptorsRepresentation serviceDescriptorsRepresentation = (ServiceDescriptorsRepresentation)this.serviceDescriptorsCodec.fromJson(Files.readAllBytes(file.toPath()));
                if (!this.environment.equals(serviceDescriptorsRepresentation.getEnvironment())) {
                    this.logServerError("Expected environment to be %s, but was %s", this.environment, serviceDescriptorsRepresentation.getEnvironment());
                }
                descriptors = Lists.newArrayList(serviceDescriptorsRepresentation.getServiceDescriptors());
            }
            catch (Exception e) {
                this.logServerError(e, "Error loading service inventory from %s", this.serviceInventoryUri.toASCIIString());
                return;
            }
        }
        try {
            descriptors = this.discoveryAddressLookup.get().stream().map(inetAddress -> {
                try {
                    return new ServiceDescriptor(UUID.nameUUIDFromBytes(inetAddress.getAddress()), null, "discovery", "general", null, ServiceState.RUNNING, (Map<String, String>)ImmutableMap.of((Object)"http", (Object)new URI("http", null, inetAddress.getHostAddress(), 4111, null, null, null).toASCIIString()));
                }
                catch (URISyntaxException e) {
                    log.error((Throwable)e, "Invalid discovery server address %s", new Object[]{inetAddress});
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Exception e) {
            this.logServerError(e, "Error looking up discovery in DNS", new Object[0]);
            return;
        }
        Collections.shuffle(descriptors);
        this.serviceDescriptors.set((List<ServiceDescriptor>)ImmutableList.copyOf((Collection)descriptors));
        this.discoveryListener.updateServiceDescriptors(Collections2.filter((Collection)descriptors, input -> "discovery".equals(input.getType())));
        if (this.serverUp.compareAndSet(false, true)) {
            log.info("ServiceInventory update succeeded", new Object[0]);
        }
    }

    private void logServerError(String message, Object ... args) {
        if (this.serverUp.compareAndSet(true, false)) {
            log.error(message, args);
        }
    }

    private void logServerError(Exception e, String message, Object ... args) {
        if (this.serverUp.compareAndSet(true, false)) {
            log.error((Throwable)e, message, args);
        }
    }
}

