/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.announce;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.proofpoint.bootstrap.StopTraffic;
import com.proofpoint.concurrent.MoreFutures;
import com.proofpoint.concurrent.Threads;
import com.proofpoint.discovery.client.DiscoveryException;
import com.proofpoint.discovery.client.ExponentialBackOff;
import com.proofpoint.discovery.client.announce.Announcer;
import com.proofpoint.discovery.client.announce.DiscoveryAnnouncementClient;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.log.Logger;
import com.proofpoint.units.Duration;
import java.net.ConnectException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class AnnouncerImpl
implements Announcer {
    private static final Logger log = Logger.get(AnnouncerImpl.class);
    private final ConcurrentMap<UUID, ServiceAnnouncement> announcements = new MapMaker().makeMap();
    private final DiscoveryAnnouncementClient announcementClient;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ExponentialBackOff errorBackOff = new ExponentialBackOff(new Duration(1.0, TimeUnit.MILLISECONDS), new Duration(1.0, TimeUnit.SECONDS), "Discovery server connect succeeded for announce", "Cannot connect to discovery server for announce", log);

    @Inject
    public AnnouncerImpl(DiscoveryAnnouncementClient announcementClient, Set<ServiceAnnouncement> serviceAnnouncements) {
        Objects.requireNonNull(announcementClient, "client is null");
        Objects.requireNonNull(serviceAnnouncements, "serviceAnnouncements is null");
        this.announcementClient = announcementClient;
        for (ServiceAnnouncement serviceAnnouncement : serviceAnnouncements) {
            this.announcements.put(serviceAnnouncement.getId(), serviceAnnouncement);
        }
        this.executor = new ScheduledThreadPoolExecutor(5, Threads.daemonThreadsNamed((String)"Announcer-%s"));
    }

    @Override
    public void start() {
        Preconditions.checkState((!this.executor.isShutdown() ? 1 : 0) != 0, (Object)"Announcer has been destroyed");
        if (this.started.compareAndSet(false, true)) {
            this.announce();
        }
    }

    @Override
    public void startIfNotKubernetes() {
        if (System.getenv("KUBERNETES_SERVICE_PORT") == null) {
            this.start();
        }
    }

    @Override
    @StopTraffic
    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.started.get()) {
            return;
        }
        try {
            MoreFutures.getFutureValue(this.announcementClient.unannounce(), DiscoveryException.class);
        }
        catch (DiscoveryException e) {
            if (e.getCause() instanceof ConnectException) {
                log.error("Cannot connect to discovery server for unannounce: %s", new Object[]{e.getCause().getMessage()});
            }
            log.error((Throwable)e);
        }
    }

    @Override
    public void addServiceAnnouncement(ServiceAnnouncement serviceAnnouncement) {
        Objects.requireNonNull(serviceAnnouncement, "serviceAnnouncement is null");
        this.announcements.put(serviceAnnouncement.getId(), serviceAnnouncement);
    }

    @Override
    public void removeServiceAnnouncement(UUID serviceId) {
        this.announcements.remove(serviceId);
    }

    private Set<ServiceAnnouncement> getServiceAnnouncements() {
        ImmutableSet announcements = ImmutableSet.copyOf(this.announcements.values());
        announcements.forEach(serviceAnnouncement -> {
            if (serviceAnnouncement.getError() != null) {
                throw new IllegalStateException(serviceAnnouncement.getError());
            }
        });
        return announcements;
    }

    private ListenableFuture<Duration> announce() {
        ListenableFuture<Duration> future = this.announcementClient.announce(this.getServiceAnnouncements());
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Duration>(){

            public void onSuccess(Duration duration) {
                AnnouncerImpl.this.errorBackOff.success();
                duration = new Duration((double)duration.toMillis() * 0.8, TimeUnit.MILLISECONDS);
                AnnouncerImpl.this.scheduleNextAnnouncement(duration);
            }

            public void onFailure(Throwable t) {
                Duration duration = AnnouncerImpl.this.errorBackOff.failed(t);
                AnnouncerImpl.this.scheduleNextAnnouncement(duration);
            }
        }, (Executor)this.executor);
        return future;
    }

    @Override
    public ListenableFuture<?> forceAnnounce() {
        return this.announcementClient.announce(this.getServiceAnnouncements());
    }

    private void scheduleNextAnnouncement(Duration delay) {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.schedule(this::announce, delay.toMillis(), TimeUnit.MILLISECONDS);
    }
}

