/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.announce;

import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.ListenableFuture;
import com.proofpoint.discovery.client.DiscoveryException;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.announce.Announcement;
import com.proofpoint.discovery.client.announce.DiscoveryAnnouncementClient;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.http.client.BodySource;
import com.proofpoint.http.client.CacheControl;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.JsonBodyGenerator;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.Response;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.units.Duration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class HttpDiscoveryAnnouncementClient
implements DiscoveryAnnouncementClient {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final NodeInfo nodeInfo;
    private final JsonCodec<Announcement> announcementCodec;
    private final HttpClient httpClient;

    @Inject
    public HttpDiscoveryAnnouncementClient(NodeInfo nodeInfo, JsonCodec<Announcement> announcementCodec, @ForDiscoveryClient HttpClient httpClient) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(announcementCodec, "announcementCodec is null");
        Objects.requireNonNull(httpClient, "httpClient is null");
        this.nodeInfo = nodeInfo;
        this.announcementCodec = announcementCodec;
        this.httpClient = httpClient;
    }

    @Override
    public ListenableFuture<Duration> announce(Set<ServiceAnnouncement> services) {
        Request.Builder builder;
        Objects.requireNonNull(services, "services is null");
        final boolean servicesEmpty = services.isEmpty();
        if (servicesEmpty) {
            builder = Request.Builder.prepareDelete();
        } else {
            Announcement announcement = new Announcement(this.nodeInfo.getEnvironment(), this.nodeInfo.getNodeId(), this.nodeInfo.getPool(), this.nodeInfo.getLocation(), services);
            builder = Request.Builder.preparePut().setHeader("Content-Type", MEDIA_TYPE_JSON.toString()).setBodySource((BodySource)JsonBodyGenerator.jsonBodyGenerator(this.announcementCodec, (Object)announcement));
        }
        Request request = builder.setUri(URI.create("v1/announcement/" + this.nodeInfo.getNodeId())).setHeader("User-Agent", this.nodeInfo.getNodeId()).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)new DiscoveryResponseHandler<Duration>("Announcement"){

            @Override
            public Duration handle(Request request, Response response) throws DiscoveryException {
                int statusCode = response.getStatusCode();
                if (statusCode == 404 && servicesEmpty) {
                    statusCode = 200;
                }
                if (!HttpDiscoveryAnnouncementClient.isSuccess(statusCode)) {
                    throw new DiscoveryException(String.format("Announcement failed with status code %s: %s", statusCode, HttpDiscoveryAnnouncementClient.getBodyForError(response)));
                }
                return HttpDiscoveryAnnouncementClient.extractMaxAge(response);
            }
        });
    }

    private static boolean isSuccess(int statusCode) {
        return statusCode / 100 == 2;
    }

    private static String getBodyForError(Response response) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return "(error getting body)";
        }
    }

    @Override
    public ListenableFuture<Void> unannounce() {
        Request request = Request.Builder.prepareDelete().setUri(URI.create("v1/announcement/" + this.nodeInfo.getNodeId())).setHeader("User-Agent", this.nodeInfo.getNodeId()).build();
        return this.httpClient.executeAsync(request, new DiscoveryResponseHandler("Unannouncement"));
    }

    private static Duration extractMaxAge(Response response) {
        CacheControl cacheControl;
        String header = response.getHeader("Cache-Control");
        if (header != null && (cacheControl = CacheControl.valueOf((String)header)).getMaxAge() > 0) {
            return new Duration((double)cacheControl.getMaxAge(), TimeUnit.SECONDS);
        }
        return DEFAULT_DELAY;
    }

    private static class DiscoveryResponseHandler<T>
    implements ResponseHandler<T, DiscoveryException> {
        private final String name;

        protected DiscoveryResponseHandler(String name) {
            this.name = name;
        }

        public T handle(Request request, Response response) {
            return null;
        }

        public final T handleException(Request request, Exception exception) {
            if (exception instanceof InterruptedException) {
                throw new DiscoveryException(this.name + " was interrupted");
            }
            if (exception instanceof CancellationException) {
                throw new DiscoveryException(this.name + " was canceled");
            }
            if (exception instanceof DiscoveryException) {
                throw (DiscoveryException)exception;
            }
            throw new DiscoveryException(this.name + " failed", exception);
        }
    }
}

