/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.announce;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceState;
import com.proofpoint.node.NodeInfo;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class ServiceAnnouncement {
    private final UUID id = UUID.randomUUID();
    private final String type;
    private final Map<String, String> properties;
    private final String error;

    private ServiceAnnouncement(String type, Map<String, String> properties) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.error = null;
    }

    private ServiceAnnouncement(String error) {
        this.type = null;
        this.properties = null;
        this.error = Objects.requireNonNull(error, "error is null");
    }

    @JsonProperty
    public UUID getId() {
        return this.id;
    }

    @JsonProperty
    public String getType() {
        if (this.error != null) {
            throw new IllegalStateException(this.error);
        }
        return this.type;
    }

    @Nullable
    public String getError() {
        return this.error;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        if (this.error != null) {
            throw new IllegalStateException(this.error);
        }
        return this.properties;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("properties", this.properties).add("error", (Object)this.error).toString();
    }

    public ServiceDescriptor toServiceDescriptor(NodeInfo nodeInfo) {
        if (this.error != null) {
            throw new IllegalStateException(this.error);
        }
        return ServiceDescriptor.serviceDescriptor(this.type).setId(this.id).setNodeInfo(nodeInfo).setLocation(nodeInfo.getLocation()).setState(ServiceState.RUNNING).addProperties(this.properties).build();
    }

    public static ServiceAnnouncementBuilder serviceAnnouncement(String type) {
        return new ServiceAnnouncementBuilder(type);
    }

    public static ServiceAnnouncement serviceAnnouncementError(String error) {
        return new ServiceAnnouncement(error);
    }

    public static class ServiceAnnouncementBuilder {
        private final String type;
        private final ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private ServiceAnnouncementBuilder(String type) {
            this.type = type;
        }

        public ServiceAnnouncementBuilder addProperty(String key, String value) {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(value, "value is null");
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        public ServiceAnnouncementBuilder addProperties(Map<String, String> properties) {
            Objects.requireNonNull(properties, "properties is null");
            this.properties.putAll(properties);
            return this;
        }

        public ServiceAnnouncement build() {
            return new ServiceAnnouncement(this.type, (Map)this.properties.build());
        }
    }
}

