/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.ServiceDescriptorsUpdater;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerListenerAdapter;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerConfig;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.http.client.balancing.HttpServiceBalancerStats;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.reporting.ReportCollectionFactory;
import com.proofpoint.reporting.ReportExporter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public final class HttpServiceBalancerFactory {
    private final DiscoveryLookupClient lookupClient;
    private final ScheduledExecutorService executor;
    private final ReportExporter reportExporter;
    private final ReportCollectionFactory reportCollectionFactory;

    @Inject
    public HttpServiceBalancerFactory(DiscoveryLookupClient lookupClient, @ForDiscoveryClient ScheduledExecutorService executor, ReportExporter reportExporter, ReportCollectionFactory reportCollectionFactory) {
        this.lookupClient = Objects.requireNonNull(lookupClient, "lookupClient is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.reportExporter = Objects.requireNonNull(reportExporter, "reportExporter is null");
        this.reportCollectionFactory = Objects.requireNonNull(reportCollectionFactory, "reportCollectionFactory is null");
    }

    public HttpServiceBalancer createHttpServiceBalancer(String type, ServiceSelectorConfig selectorConfig, HttpServiceBalancerConfig balancerConfig, NodeInfo nodeInfo) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        Objects.requireNonNull(balancerConfig, "balancerConfig is null");
        String pool = (String)MoreObjects.firstNonNull((Object)selectorConfig.getPool(), (Object)nodeInfo.getPool());
        ImmutableMap tags = ImmutableMap.of((Object)"serviceType", (Object)type);
        HttpServiceBalancerStats httpServiceBalancerStats = (HttpServiceBalancerStats)this.reportCollectionFactory.createReportCollection(HttpServiceBalancerStats.class, false, "ServiceClient", (Map)tags);
        HttpServiceBalancerImpl balancer = new HttpServiceBalancerImpl(String.format("type=[%s], pool=[%s]", type, pool), httpServiceBalancerStats, balancerConfig);
        this.reportExporter.export((Object)balancer, false, "ServiceClient", (Map)tags);
        ServiceDescriptorsUpdater updater = new ServiceDescriptorsUpdater(new HttpServiceBalancerListenerAdapter(balancer), type, selectorConfig, nodeInfo, this.lookupClient, this.executor);
        updater.start();
        return balancer;
    }
}

