/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.collect.ImmutableMultiset;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptorsListener;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;

public class HttpServiceBalancerListenerAdapter
implements ServiceDescriptorsListener {
    private final HttpServiceBalancerImpl balancer;

    public HttpServiceBalancerListenerAdapter(HttpServiceBalancerImpl balancer) {
        this.balancer = balancer;
    }

    @Override
    public void updateServiceDescriptors(Iterable<ServiceDescriptor> newDescriptors) {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        for (ServiceDescriptor serviceDescriptor : newDescriptors) {
            Map<String, String> properties = serviceDescriptor.getProperties();
            int weight = 1;
            String weightString = properties.get("weight");
            if (weightString != null) {
                try {
                    weight = (int)Double.parseDouble(weightString);
                    if (weight < 0) {
                        weight = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String https = properties.get("https");
            URI uri = null;
            if (https != null) {
                try {
                    uri = new URI(https);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            String http = properties.get("http");
            if (uri == null && http != null) {
                try {
                    uri = new URI(http);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (uri == null) continue;
            for (int i = 0; i < weight; ++i) {
                builder.add((Object)uri);
            }
        }
        this.balancer.updateHttpUris((Collection)builder.build());
    }
}

